/*
 * Decompiled with CFR 0.152.
 */
package com.saucelabs.common;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;

public class SauceOnDemandAuthentication {
    private String username = "";
    private String accessKey = "";
    private static final String SAUCE_USER_NAME = "SAUCE_USER_NAME";
    private static final String SAUCE_USERNAME = "SAUCE_USERNAME";
    private static final String SAUCE_API_KEY = "SAUCE_API_KEY";
    private static final String SAUCE_ACCESS_KEY = "SAUCE_ACCESS_KEY";

    public SauceOnDemandAuthentication() {
        this.username = SauceOnDemandAuthentication.getPropertyOrEnvironmentVariable(SAUCE_USER_NAME);
        if (this.username == null || this.username.equals("")) {
            this.username = SauceOnDemandAuthentication.getPropertyOrEnvironmentVariable(SAUCE_USERNAME);
        }
        this.accessKey = SauceOnDemandAuthentication.getPropertyOrEnvironmentVariable(SAUCE_API_KEY);
        if (this.accessKey == null || this.accessKey.equals("")) {
            this.accessKey = SauceOnDemandAuthentication.getPropertyOrEnvironmentVariable(SAUCE_ACCESS_KEY);
        }
        if (this.username == null || this.accessKey == null) {
            this.loadCredentialsFromFile(SauceOnDemandAuthentication.getDefaultCredentialFile());
        }
    }

    public SauceOnDemandAuthentication(String username, String accessKey) {
        this.username = username;
        this.accessKey = accessKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadCredentialsFromFile(File propertyFile) {
        Properties props = new Properties();
        FileInputStream in = null;
        try {
            if (propertyFile.exists()) {
                in = new FileInputStream(propertyFile);
                props.load(in);
                this.username = props.getProperty("username");
                this.accessKey = props.getProperty("key");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {}
        }
    }

    public static File getDefaultCredentialFile() {
        return new File(new File(System.getProperty("user.home")), ".sauce-ondemand");
    }

    private static String getPropertyOrEnvironmentVariable(String property) {
        String value = System.getProperty(property);
        if (value == null || value.equals("")) {
            value = System.getenv(property);
        }
        return value;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveTo(File propertyFile) throws IOException {
        Properties props = new Properties();
        props.put("username", this.username);
        props.put("key", this.accessKey);
        FileOutputStream out = new FileOutputStream(propertyFile);
        try {
            props.store(out, "Sauce OnDemand access credential");
        }
        finally {
            out.close();
        }
    }
}

