/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.service.prov.api.security;

import com.google.gson.JsonObject;
import com.sap.cloud.sdk.service.prov.api.security.AuthorizationExpressionParser;
import com.sap.cloud.sdk.service.prov.api.security.Operator;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpressionExecutorUtil {
    public static final String SPECIAL = "SPECIAL~";
    public static final String EMPTY = "";
    private static final Logger logger = LoggerFactory.getLogger(ExpressionExecutorUtil.class);
    private static final String SCRIPT_ENGINE = "JavaScript";
    public static final String SKIP_VALUE = "#SKIPVAL#";
    public static final String TRUE_EXP = "1=1";

    private ExpressionExecutorUtil() {
    }

    public static boolean executeExpression(String expression) throws ScriptException {
        boolean result = false;
        ScriptEngineManager manager = new ScriptEngineManager();
        ScriptEngine engine = manager.getEngineByName(SCRIPT_ENGINE);
        try {
            expression = expression.replaceAll("=", "===");
            result = (Boolean)engine.eval(expression);
        }
        catch (ScriptException e) {
            logger.error(e.getMessage());
            throw e;
        }
        return result;
    }

    public static String buildExpression(String expression, JsonObject attributes) {
        String[] tokens = ExpressionExecutorUtil.tokenizer(expression);
        boolean isSpecial = AuthorizationExpressionParser.transformValueAndCheckIfSpecial(tokens, attributes);
        StringBuilder pseudoSql = AuthorizationExpressionParser.convertToPseudoSql(tokens);
        if (pseudoSql == null) {
            isSpecial = false;
            return TRUE_EXP;
        }
        if (isSpecial) {
            pseudoSql.insert(0, SPECIAL).toString();
        }
        return pseudoSql.toString();
    }

    public static String[] tokenizer(String exp2) {
        String exp = exp2.trim().replaceAll(" +", " ").replaceAll(Operator.GT_EQ.getValue(), Operator.GT_EQ.getEncodedValue()).replaceAll(Operator.ST_EQ.getValue(), Operator.ST_EQ.getEncodedValue()).replaceAll(Operator.GT.getValue(), Operator.GT.getEncodedValue()).replaceAll(Operator.ST.getValue(), Operator.ST.getEncodedValue()).replaceAll(Operator.NOT_EQ.getValue(), Operator.NOT_EQ.getEncodedValue()).replaceAll(Operator.EQ.getValue(), Operator.EQ.getEncodedValue()).replaceAll(Operator.NOT.getValue(), Operator.NOT.getEncodedValue());
        String delims = "(?=\\()|(?<=\\()|(?=\\))|(?<=\\))|(?=\\s)|(?<=\\s)|(?=,)|(?<=,)";
        delims = delims + "|(?=" + Operator.GT.getEncodedValue() + ")|(?<=" + Operator.GT.getEncodedValue() + ")";
        delims = delims + "|(?=" + Operator.GT_EQ.getEncodedValue() + ")|(?<=" + Operator.GT_EQ.getEncodedValue() + ")";
        delims = delims + "|(?=" + Operator.ST.getEncodedValue() + ")|(?<=" + Operator.ST.getEncodedValue() + ")";
        delims = delims + "|(?=" + Operator.ST_EQ.getEncodedValue() + ")|(?<=" + Operator.ST_EQ.getEncodedValue() + ")";
        delims = delims + "|(?=" + Operator.NOT_EQ.getEncodedValue() + ")|(?<=" + Operator.NOT_EQ.getEncodedValue() + ")";
        delims = delims + "|(?=" + Operator.EQ.getEncodedValue() + ")|(?<=" + Operator.EQ.getEncodedValue() + ")";
        delims = delims + "|(?=" + Operator.NOT.getEncodedValue() + ")|(?<=" + Operator.NOT.getEncodedValue() + ")";
        String[] tokens = exp.split(delims);
        return tokens;
    }
}

