/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.service.prov.api.security;

import com.sap.cloud.sdk.service.prov.api.security.Authorization;
import com.sap.cloud.sdk.service.prov.api.security.AuthorizationDetails;
import com.sap.cloud.sdk.service.prov.api.security.AuthorizationRulesContainer;
import com.sap.cloud.sdk.service.prov.api.security.JWTUtil;
import com.sap.cloud.sdk.service.prov.api.security.SecurityUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerSecurityImpl
extends Authorization {
    private static final Logger log = LoggerFactory.getLogger(ContainerSecurityImpl.class);

    @Override
    public boolean isAuthenticatedUser(String serviceName) {
        AuthorizationDetails authDetails = AuthorizationRulesContainer.getRule(serviceName);
        if (authDetails == null) {
            log.debug("No authorization details found for the Service: {} ", (Object)serviceName);
            return false;
        }
        return SecurityUtil.isAuthenticatedUser(authDetails, serviceName);
    }

    @Override
    public boolean isRegisteredUser(String serviceName) {
        return this.isAuthenticatedUser(serviceName);
    }

    @Override
    public boolean hasEntityAccess(String entityName, String operation) {
        log.debug("Authorization Check for Service: {} and Operation: {}", (Object)entityName, (Object)operation);
        return SecurityUtil.hasEntityAccess(entityName, operation);
    }

    @Override
    public String getUserName() {
        return SecurityUtil.getUserName();
    }

    @Override
    public String getUserId() {
        return SecurityUtil.getUserId();
    }

    @Override
    public boolean hasUserRole(String roleName) {
        return SecurityUtil.hasUserRole(roleName);
    }

    @Override
    public String getUserAttribute(String attributeName) {
        return JWTUtil.getJWTAttribute(attributeName);
    }
}

