/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.service.prov.api.security;

import com.sap.cloud.sdk.service.prov.api.security.AuthorizationService;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import javax.servlet.annotation.WebListener;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebListener
public class AuthorizationListener
implements ServletRequestListener {
    private static final Logger log = LoggerFactory.getLogger(AuthorizationListener.class);

    public void requestDestroyed(ServletRequestEvent sre) {
        log.debug("Destroying Authorization as it is end of request.");
        AuthorizationService.purgeCurrentAuthorization();
    }

    public void requestInitialized(ServletRequestEvent sre) {
        log.debug("Reading user principal");
        HttpServletRequest req = (HttpServletRequest)sre.getServletRequest();
        String jwtTokenAsStr = req.getHeader("authorization");
        if (null != jwtTokenAsStr) {
            jwtTokenAsStr = jwtTokenAsStr.replace("Bearer ", "");
            AuthorizationService.setJWTToken(jwtTokenAsStr);
        }
    }
}

