/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.service.prov.api.internal;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.sap.cloud.sdk.service.prov.api.EntityData;
import com.sap.cloud.sdk.service.prov.api.EntityMetadata;
import com.sap.cloud.sdk.service.prov.api.exception.DataConversionException;
import com.sap.cloud.sdk.service.prov.api.internal.HasMetadata;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class DefaultEntityData
extends EntityData
implements HasMetadata {
    Map<String, Object> properties;
    EntityMetadata em;
    Map<String, Object> associationProperties = new HashMap<String, Object>();

    public DefaultEntityData(Map<String, Object> propertyMap, EntityMetadata entityMetadata) {
        this.properties = propertyMap;
        this.em = entityMetadata;
    }

    public DefaultEntityData(Map<String, Object> propertyMap, Map<String, Object> associationPropertiesMap, EntityMetadata entityMetadata) {
        this.properties = propertyMap;
        this.em = entityMetadata;
        this.associationProperties = associationPropertiesMap;
    }

    @Override
    protected Object getPropertyValue(String name) {
        return this.properties.get(name);
    }

    @Override
    public boolean contains(String name) {
        return this.properties.containsKey(name);
    }

    @Override
    public EntityMetadata getEntityMetadata() {
        return this.em;
    }

    @Override
    public Map<String, Object> getMap() {
        return this.properties;
    }

    @Override
    public Map<String, Object> asMap() {
        return (Map)DefaultEntityData.cloneDeepMap(this.properties, this.associationProperties);
    }

    private static Object cloneDeepMap(Map<String, Object> properties, Map<String, Object> associationProperties) {
        HashMap cloned = (HashMap)DefaultEntityData.cloneMap(properties);
        if (associationProperties == null || associationProperties.isEmpty()) {
            return cloned;
        }
        for (Map.Entry<String, Object> entry : associationProperties.entrySet()) {
            Object obj = associationProperties.get(entry.getKey());
            if (obj instanceof ArrayList) {
                ArrayList<Object> cnvList = new ArrayList<Object>();
                ArrayList list = (ArrayList)obj;
                if (list.isEmpty()) {
                    cloned.put(entry.getKey(), cnvList);
                }
                for (int i = 0; i < list.size(); ++i) {
                    Object item = list.get(i);
                    if (item instanceof EntityData) {
                        EntityData entityData = (EntityData)item;
                        cnvList.add(DefaultEntityData.cloneDeepMap(entityData.getMap(), entityData.getAssociations()));
                        cloned.put(entry.getKey(), cnvList);
                        continue;
                    }
                    cnvList.add(DefaultEntityData.cloneProperty(item));
                    cloned.put(entry.getKey(), cnvList);
                }
                continue;
            }
            if (obj instanceof EntityData) {
                EntityData entityData = (EntityData)obj;
                cloned.put(entry.getKey(), DefaultEntityData.cloneDeepMap(entityData.getMap(), entityData.getAssociations()));
                continue;
            }
            cloned.put(entry.getKey(), DefaultEntityData.cloneProperty(obj));
        }
        return cloned;
    }

    @Override
    public <T> T as(Class<T> t) throws DataConversionException {
        Object pojo;
        Map<String, Object> copy = this.asMap();
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(SerializationFeature.WRITE_NULL_MAP_VALUES, false);
        mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        mapper.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.NONE);
        mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        try {
            pojo = mapper.convertValue(copy, Class.forName(t.getTypeName()));
        }
        catch (ClassNotFoundException | IllegalArgumentException e) {
            throw new DataConversionException(e.getMessage(), e.getCause());
        }
        return (T)pojo;
    }

    @Override
    public Object getAssociationValue(String name) {
        if (this.associationProperties != null) {
            return this.associationProperties.get(name);
        }
        return null;
    }

    @Override
    public Map<String, Object> getAssociations() {
        return this.associationProperties;
    }
}

