/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.service.prov.api.filter.impl;

import com.sap.cloud.sdk.service.prov.api.filter.Expression;
import com.sap.cloud.sdk.service.prov.api.filter.ExpressionBuilder;
import com.sap.cloud.sdk.service.prov.api.filter.ExpressionOperatorTypes;
import com.sap.cloud.sdk.service.prov.api.filter.exception.FilterOptionException;
import com.sap.cloud.sdk.service.prov.api.filter.impl.BinaryExpressionNodeImpl;
import com.sap.cloud.sdk.service.prov.api.filter.impl.FilterNodeInternal;
import com.sap.cloud.sdk.service.prov.api.filter.impl.LiteralNodeImpl;
import com.sap.cloud.sdk.service.prov.api.filter.impl.NodeInfoImpl;
import com.sap.cloud.sdk.service.prov.api.filter.impl.PropertyNodeImpl;
import com.sap.cloud.sdk.service.prov.api.filter.impl.UnaryExpressionNodeImpl;

public class ExpressionBuilderImpl
implements ExpressionBuilder {
    @Override
    public Expression createExpression(String path, ExpressionOperatorTypes.BINARY_OPERATOR operator, Object value) throws FilterOptionException {
        switch (operator.name()) {
            case "EQ": 
            case "NE": 
            case "LT": 
            case "GT": 
            case "LE": 
            case "GE": {
                break;
            }
            default: {
                throw new FilterOptionException("Only EQ, NE, LT, GT, LE, GE are supported");
            }
        }
        NodeInfoImpl literalNodeInfo = new NodeInfoImpl(ExpressionOperatorTypes.NODE_KIND.LITERAL);
        literalNodeInfo.setCustomNode(true);
        LiteralNodeImpl literalNode = new LiteralNodeImpl(value, literalNodeInfo);
        NodeInfoImpl propertyNodeInfo = new NodeInfoImpl("", ExpressionOperatorTypes.NODE_KIND.PROPERTY);
        propertyNodeInfo.setCustomNode(true);
        PropertyNodeImpl simpleMember = new PropertyNodeImpl(path, propertyNodeInfo);
        NodeInfoImpl binaryNodeInfo = new NodeInfoImpl(operator.name(), ExpressionOperatorTypes.NODE_KIND.BINARY);
        binaryNodeInfo.setCustomNode(true);
        return new BinaryExpressionNodeImpl(literalNode, simpleMember, binaryNodeInfo);
    }

    @Override
    public Expression createExpression(Expression left, ExpressionOperatorTypes.BINARY_OPERATOR operator, Expression right) throws FilterOptionException {
        switch (operator.name()) {
            case "AND": 
            case "OR": {
                break;
            }
            default: {
                throw new FilterOptionException("Only AND , OR operators supported");
            }
        }
        NodeInfoImpl binaryNodeInfo = new NodeInfoImpl(operator.name(), ExpressionOperatorTypes.NODE_KIND.BINARY);
        binaryNodeInfo.setCustomNode(true);
        BinaryExpressionNodeImpl exp = new BinaryExpressionNodeImpl((FilterNodeInternal)left, (FilterNodeInternal)right, binaryNodeInfo);
        return exp;
    }

    @Override
    public Expression not(Expression expression) {
        return new UnaryExpressionNodeImpl((FilterNodeInternal)expression, new NodeInfoImpl(ExpressionOperatorTypes.UNARY_OPERATOR.NOT.name(), ExpressionOperatorTypes.NODE_KIND.UNARY));
    }

    @Override
    public Expression and(Expression left, Expression right) {
        return new BinaryExpressionNodeImpl((FilterNodeInternal)left, (FilterNodeInternal)right, new NodeInfoImpl(ExpressionOperatorTypes.BINARY_OPERATOR.AND.name(), ExpressionOperatorTypes.NODE_KIND.BINARY));
    }
}

