/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.xsuaa.client;

import com.sap.cloud.security.config.CredentialType;
import com.sap.cloud.security.config.OAuth2ServiceConfiguration;
import com.sap.cloud.security.xsuaa.Assertions;
import com.sap.cloud.security.xsuaa.client.OAuth2ServiceEndpointsProvider;
import com.sap.cloud.security.xsuaa.util.UriUtil;
import java.net.URI;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XsuaaDefaultEndpoints
implements OAuth2ServiceEndpointsProvider {
    private final URI baseUri;
    private final URI certUri;
    private static final String TOKEN_ENDPOINT = "/oauth/token";
    private static final String AUTHORIZE_ENDPOINT = "/oauth/authorize";
    private static final String KEYSET_ENDPOINT = "/token_keys";
    private static final Logger LOGGER = LoggerFactory.getLogger(XsuaaDefaultEndpoints.class);

    public XsuaaDefaultEndpoints(@Nonnull String baseUri, @Nullable String certUri) {
        Assertions.assertNotNull(baseUri, "XSUAA base URI must not be null.");
        LOGGER.debug("Xsuaa default service endpoint: base url = {}, (cert url = {})", (Object)baseUri, (Object)certUri);
        this.baseUri = URI.create(baseUri);
        this.certUri = certUri != null ? URI.create(certUri) : null;
    }

    public XsuaaDefaultEndpoints(@Nonnull OAuth2ServiceConfiguration config) {
        Assertions.assertNotNull(config, "OAuth2ServiceConfiguration must not be null.");
        this.baseUri = config.getUrl();
        CredentialType credentialType = config.getCredentialType() != null ? config.getCredentialType() : CredentialType.BINDING_SECRET;
        this.certUri = switch (credentialType) {
            default -> throw new IncompatibleClassChangeError();
            case CredentialType.X509, CredentialType.X509_GENERATED, CredentialType.X509_PROVIDED, CredentialType.X509_ATTESTED -> config.getCertUrl();
            case CredentialType.BINDING_SECRET, CredentialType.INSTANCE_SECRET -> null;
        };
    }

    @Override
    public URI getTokenEndpoint() {
        return UriUtil.expandPath(this.certUri != null ? this.certUri : this.baseUri, TOKEN_ENDPOINT);
    }

    @Override
    public URI getAuthorizeEndpoint() {
        return UriUtil.expandPath(this.certUri != null ? this.certUri : this.baseUri, AUTHORIZE_ENDPOINT);
    }

    @Override
    public URI getJwksUri() {
        Assertions.assertNotNull(this.baseUri, "XsuaaDefaultEndpoints.getJwksUri() requires baseUri not to be null.");
        return UriUtil.expandPath(this.baseUri, KEYSET_ENDPOINT);
    }
}

