/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.servlet.response.serializer;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.sap.cloud.sdk.cloudplatform.exception.StringParsingException;
import com.sap.cloud.sdk.cloudplatform.servlet.response.serializer.GsonSerializer;
import com.sap.cloud.sdk.cloudplatform.util.StringConverter;
import java.lang.reflect.Type;
import java.time.LocalDate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class LocalDateGsonSerializer
implements GsonSerializer<LocalDate> {
    @Nonnull
    public JsonElement serialize(@Nullable LocalDate src, @Nonnull Type typeOfSrc, @Nonnull JsonSerializationContext context) {
        String str = StringConverter.toString((LocalDate)src);
        if (str == null) {
            return JsonNull.INSTANCE;
        }
        return new JsonPrimitive(str);
    }

    @Nullable
    public LocalDate deserialize(@Nonnull JsonElement json, @Nonnull Type typeOfT, @Nonnull JsonDeserializationContext context) throws JsonParseException {
        try {
            return StringConverter.toLocalDate((String)json.toString().replace("\"", ""));
        }
        catch (StringParsingException e) {
            throw new JsonParseException((Throwable)e);
        }
    }
}

