/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.security;

import com.sap.cloud.sdk.cloudplatform.requestheader.RequestHeaderAccessor;
import com.sap.cloud.sdk.cloudplatform.requestheader.RequestHeaderContainer;
import com.sap.cloud.sdk.cloudplatform.security.BasicAuthenticationFacade;
import com.sap.cloud.sdk.cloudplatform.security.BasicAuthenticationThreadContextListener;
import com.sap.cloud.sdk.cloudplatform.security.BasicCredentials;
import com.sap.cloud.sdk.cloudplatform.security.exception.BasicAuthenticationAccessException;
import com.sap.cloud.sdk.cloudplatform.thread.ThreadContext;
import com.sap.cloud.sdk.cloudplatform.thread.ThreadContextAccessor;
import io.vavr.control.Try;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;

public class DefaultBasicAuthenticationFacade
implements BasicAuthenticationFacade {
    private static final String PROPERTY = BasicAuthenticationThreadContextListener.PROPERTY_BASIC_AUTH_HEADER;
    private static final Pattern CASE_INSENSITIVE_BASIC_PREFIX_MATCH = Pattern.compile("^(?i)basic(?-i) \\s*([A-Za-z0-9+/=]+)\\s*$");

    @Override
    @Nonnull
    public Try<BasicCredentials> tryGetBasicCredentials() {
        ThreadContext context = ThreadContextAccessor.getCurrentContextOrNull();
        if (context != null && context.containsProperty(PROPERTY)) {
            return context.getPropertyValue(PROPERTY);
        }
        return Try.of(this::extractBasicCredentialsFromHeaderOrThrow);
    }

    private BasicCredentials extractBasicCredentialsFromHeaderOrThrow() {
        RequestHeaderContainer headers = (RequestHeaderContainer)RequestHeaderAccessor.tryGetHeaderContainer().getOrElseThrow(e -> new BasicAuthenticationAccessException("Unable to resolve basic credentials: Unable to read request headers.", (Throwable)e));
        String value = this.selectBasicAuthenticationHeaderOrThrow(headers.getHeaderValues("Authorization"));
        String valueBase64 = this.extractBasicHeaderValueOrThrow(value);
        return this.decodeBasicCredentialsOrThrow(valueBase64);
    }

    private String selectBasicAuthenticationHeaderOrThrow(List<String> allAuthenticationHeader) {
        if (allAuthenticationHeader.isEmpty()) {
            throw new BasicAuthenticationAccessException("Unable to resolve basic credentials: Received an 'Authorization' header without a value.");
        }
        if (allAuthenticationHeader.size() > 1) {
            throw new BasicAuthenticationAccessException("Unable to resolve basic credentials: Received multiple 'Authorization' headers with the request, but the specification allows at most one.");
        }
        return allAuthenticationHeader.get(0);
    }

    private String extractBasicHeaderValueOrThrow(CharSequence completeHeader) {
        Matcher match = CASE_INSENSITIVE_BASIC_PREFIX_MATCH.matcher(completeHeader);
        if (!match.matches()) {
            throw new BasicAuthenticationAccessException("Unable to resolve basic credentials: The 'Authorization' header did not contain a Basic Authentication header field.");
        }
        return match.group(1);
    }

    private BasicCredentials decodeBasicCredentialsOrThrow(String base64Credentials) {
        try {
            String[] credentials = new String(Base64.getDecoder().decode(base64Credentials), StandardCharsets.UTF_8).split(":");
            return new BasicCredentials(credentials[0], credentials[1]);
        }
        catch (ArrayIndexOutOfBoundsException | IllegalArgumentException e) {
            throw new BasicAuthenticationAccessException("Unable to resolve basic credentials: Invalid format.", e);
        }
    }
}

