/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.security;

import com.sap.cloud.sdk.cloudplatform.requestheader.RequestHeaderAccessor;
import com.sap.cloud.sdk.cloudplatform.security.AuthToken;
import com.sap.cloud.sdk.cloudplatform.security.AuthTokenDecoder;
import com.sap.cloud.sdk.cloudplatform.security.AuthTokenDecoderDefault;
import com.sap.cloud.sdk.cloudplatform.security.AuthTokenThreadContextListener;
import com.sap.cloud.sdk.cloudplatform.security.ExecutableAuthTokenFacade;
import com.sap.cloud.sdk.cloudplatform.thread.ThreadContext;
import com.sap.cloud.sdk.cloudplatform.thread.ThreadContextAccessor;
import com.sap.cloud.sdk.cloudplatform.thread.ThreadContextExecutor;
import com.sap.cloud.sdk.cloudplatform.thread.ThreadContextListener;
import com.sap.cloud.sdk.cloudplatform.thread.exception.ThreadContextExecutionException;
import io.vavr.control.Try;
import java.util.concurrent.Callable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAuthTokenFacade
extends ExecutableAuthTokenFacade {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultAuthTokenFacade.class);
    @Nonnull
    private AuthTokenDecoder tokenDecoder;

    public DefaultAuthTokenFacade() {
        this(new AuthTokenDecoderDefault());
    }

    @Override
    @Nonnull
    public Try<AuthToken> tryGetCurrentToken() {
        ThreadContext currentContext = ThreadContextAccessor.getCurrentContextOrNull();
        if (currentContext != null && currentContext.containsProperty(AuthTokenThreadContextListener.PROPERTY_AUTH_TOKEN)) {
            return currentContext.getPropertyValue(AuthTokenThreadContextListener.PROPERTY_AUTH_TOKEN);
        }
        return RequestHeaderAccessor.tryGetHeaderContainer().flatMap(this.tokenDecoder::decode);
    }

    @Override
    @Nullable
    protected <T> T executeWithAuthToken(@Nonnull AuthToken authToken, @Nonnull Callable<T> callable) throws ThreadContextExecutionException {
        return (T)ThreadContextExecutor.fromCurrentOrNewContext().withListeners(new ThreadContextListener[]{new AuthTokenThreadContextListener(authToken)}).execute(callable);
    }

    @Generated
    DefaultAuthTokenFacade(@Nonnull AuthTokenDecoder tokenDecoder) {
        if (tokenDecoder == null) {
            throw new NullPointerException("tokenDecoder is marked non-null but is null");
        }
        this.tokenDecoder = tokenDecoder;
    }
}

