/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.security.principal;

import com.sap.cloud.sdk.cloudplatform.security.principal.Principal;
import com.sap.cloud.sdk.cloudplatform.security.principal.PrincipalAccessor;
import com.sap.cloud.sdk.cloudplatform.thread.Property;
import com.sap.cloud.sdk.cloudplatform.thread.ThreadContext;
import com.sap.cloud.sdk.cloudplatform.thread.ThreadContextListener;
import io.vavr.control.Try;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class PrincipalThreadContextListener
implements ThreadContextListener {
    public static final String PROPERTY_PRINCIPAL = PrincipalThreadContextListener.class.getName() + ":principal";
    @Nullable
    private final Principal principal;

    public PrincipalThreadContextListener() {
        this.principal = null;
    }

    public PrincipalThreadContextListener(@Nonnull Principal principal) {
        this.principal = principal;
    }

    public int getPriority() {
        return -4;
    }

    public void afterInitialize(@Nonnull ThreadContext threadContext, @Nullable ThreadContext parentThreadContext) {
        Try principalTry = this.principal != null ? Try.success((Object)this.principal) : (parentThreadContext != null ? parentThreadContext.getProperty(PROPERTY_PRINCIPAL).map(Property::getValue).orElse(PrincipalAccessor::tryGetCurrentPrincipal) : PrincipalAccessor.tryGetCurrentPrincipal());
        threadContext.setPropertyIfAbsent(PROPERTY_PRINCIPAL, Property.ofTry(principalTry));
    }

    public void beforeDestroy(@Nonnull ThreadContext threadContext, @Nullable ThreadContext parentThreadContext) {
        threadContext.removeProperty(PROPERTY_PRINCIPAL);
    }
}

