/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.connectivity;

import com.google.common.escape.Escaper;
import com.google.common.net.PercentEscaper;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.cloudplatform.util.StringUtils;
import io.vavr.control.Try;
import java.util.Collection;
import java.util.LinkedList;
import javax.annotation.Nonnull;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class QueryParamGetter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(QueryParamGetter.class);
    private static final String URL_QUERIES = "URL.queries.";
    private static final Escaper URL_QUERY_ESCAPER = new PercentEscaper("_*-:,/'().|", false);

    QueryParamGetter() {
    }

    @Nonnull
    static Collection<String> getQueryParameters(HttpDestinationProperties baseProperties) {
        Iterable propertyKeys = baseProperties.getPropertyNames();
        LinkedList<String> queryParams = new LinkedList<String>();
        for (String propertyKey : propertyKeys) {
            if (!StringUtils.startsWithIgnoreCase((String)propertyKey, (String)URL_QUERIES)) continue;
            Try propertyValue = baseProperties.get(propertyKey).toTry().map(String.class::cast);
            if (propertyValue.isSuccess()) {
                String queryParam = URL_QUERY_ESCAPER.escape(propertyKey.substring(URL_QUERIES.length())) + "=" + URL_QUERY_ESCAPER.escape((String)propertyValue.get());
                queryParams.add(queryParam);
                continue;
            }
            String msg = "Cannot find value for property \"{}\" defined in destination. Skipping the query parameter.";
            log.debug("Cannot find value for property \"{}\" defined in destination. Skipping the query parameter.", (Object)propertyKey);
        }
        return queryParams;
    }
}

