/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.security.secret;

import com.sap.cloud.sdk.cloudplatform.security.secret.SecretStore;
import com.sap.cloud.sdk.cloudplatform.security.secret.SecretStoreFacade;
import com.sap.cloud.sdk.cloudplatform.security.secret.exception.KeyStoreAccessException;
import com.sap.cloud.sdk.cloudplatform.security.secret.exception.KeyStoreNotFoundException;
import com.sap.cloud.sdk.cloudplatform.security.secret.exception.SecretStoreAccessException;
import com.sap.cloud.sdk.cloudplatform.security.secret.exception.SecretStoreNotFoundException;
import java.security.KeyStore;
import java.util.Optional;
import javax.annotation.Nonnull;

public abstract class AbstractSecretStoreFacade
implements SecretStoreFacade {
    @Override
    @Nonnull
    public SecretStore getSecretStore(String name) throws SecretStoreNotFoundException, SecretStoreAccessException {
        Optional<SecretStore> secretStore = this.getSecretStoreIfPresent(name);
        if (!secretStore.isPresent()) {
            throw new SecretStoreNotFoundException("Failed to find secret store with name '" + name + "'.");
        }
        return secretStore.get();
    }

    @Override
    @Nonnull
    public KeyStore getKeyStore(String name, SecretStore password) throws KeyStoreNotFoundException, KeyStoreAccessException {
        Optional<KeyStore> keyStore = this.getKeyStoreIfPresent(name, password);
        if (!keyStore.isPresent()) {
            throw new KeyStoreNotFoundException("Failed to find key store with name '" + name + "'.");
        }
        return keyStore.get();
    }
}

