/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.security.servlet;

import com.google.common.collect.Sets;
import java.util.Set;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.joda.time.DateTime;

public class HttpCachingHeaderWrapper
extends HttpServletResponseWrapper {
    public static final Set<String> CACHEABLE_CONTENT_TYPES = Sets.newHashSet((Object[])new String[]{"text/css", "text/javascript", "image/webp", "image/png", "image/jpeg", "image/gif", "image/jpg", "image/svg+xml", "application/javascript", "application/xml", "application/css", "application/x-font-woff", "application/x-font-ttf"});

    public HttpCachingHeaderWrapper(HttpServletResponse response) {
        super(response);
    }

    public void setContentType(@Nullable String contentType) {
        if (contentType != null && CACHEABLE_CONTENT_TYPES.contains(contentType.toLowerCase())) {
            DateTime dt = DateTime.now().plusDays(1);
            super.setDateHeader("Expires", dt.getMillis());
        } else {
            super.setHeader("Cache-Control", "no-cache, no-store");
            super.setHeader("Expires", "0");
        }
        super.setContentType(contentType);
    }
}

