/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.sdk.cmd.mojo;

import com.sap.core.sdk.cmd.mojo.AbstractConsoleCommandMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.crypto.DefaultSettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecrypter;
import org.apache.maven.settings.crypto.SettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecryptionResult;

public abstract class AbstractRemoteConsoleCommandMojo
extends AbstractConsoleCommandMojo {
    @Parameter(property="mavenSettingsServerId", readonly=false, required=false)
    public String mavenSettingsServerId;
    @Component
    private Settings settings;
    @Component
    private SettingsDecrypter settingsDecrypter;

    @Override
    protected void run(String command) throws MojoExecutionException {
        if (this.mavenSettingsServerId != null && !this.mavenSettingsServerId.trim().isEmpty()) {
            String newCommand;
            String newCommand2;
            Server server = this.getServerFromSettingsById(this.mavenSettingsServerId);
            boolean usingUsernameFromServer = false;
            if (server.getUsername() != null && !server.getUsername().trim().isEmpty() && !command.equals(newCommand2 = this.mixInArg(command, "--user", server.getUsername()))) {
                usingUsernameFromServer = true;
                command = newCommand2;
            }
            boolean usingPasswordFromServer = false;
            if (server.getPassword() != null && !server.getPassword().trim().isEmpty() && !command.equals(newCommand = this.mixInArg(command, "--password", server.getPassword()))) {
                usingPasswordFromServer = true;
                command = newCommand;
            }
            if (usingUsernameFromServer && usingPasswordFromServer) {
                this.getLog().info((CharSequence)("Using user name and encrypted password of server entry " + this.mavenSettingsServerId + " to authenticate to SAP HANA Cloud."));
            } else if (usingUsernameFromServer) {
                this.getLog().info((CharSequence)("Using user name of server entry " + this.mavenSettingsServerId + " to authenticate to SAP HANA Cloud."));
            } else if (usingPasswordFromServer) {
                this.getLog().info((CharSequence)("Using encrypted password of server entry " + this.mavenSettingsServerId + " to authenticate to SAP HANA Cloud."));
            }
        }
        super.run(command);
    }

    private Server getServerFromSettingsById(String id) {
        DefaultSettingsDecryptionRequest settingsDecryptionRequest = new DefaultSettingsDecryptionRequest();
        settingsDecryptionRequest.setServers(this.settings.getServers());
        SettingsDecryptionResult decrypt = this.settingsDecrypter.decrypt((SettingsDecryptionRequest)settingsDecryptionRequest);
        for (Server server : decrypt.getServers()) {
            if (!id.equals(server.getId())) continue;
            if (server.getPassword() != null && !server.getPassword().trim().isEmpty() && server.getPassword().equals(this.settings.getServer(id).getPassword())) {
                throw new RuntimeException("Maven settings server entry " + this.mavenSettingsServerId + " was found, but password can not be decrypted. Did you follow the instructions in http://maven.apache.org/guides/mini/guide-encryption.html and have created a master password, put it into settings-security.xml and made that file available in the default location ~/.m2 or configured its location with -Dsettings.security=/path/to/settings-security.xml?");
            }
            return server;
        }
        throw new IllegalArgumentException("Maven settings server ID " + this.mavenSettingsServerId + " was configured, but settings.xml doesn't contain server entry with this ID!");
    }
}

