/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.sdk.cmd.mojo;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.sap.core.sdk.cmd.mojo.OsName;
import com.sap.core.sdk.cmd.mojo.SdkVersion;
import com.sap.core.sdk.cmd.mojo.StreamReader;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public abstract class AbstractConsoleCommandMojo
extends AbstractMojo {
    private static final String CONSOLE_SHELL_WINDOWS = "cmd";
    private static final String CONSOLE_SCRIPT_WINDOWS = "/c neo.bat";
    private static final String CONSOLE_SHELL_UNIX = "sh";
    private static final String CONSOLE_SCRIPT_UNIX = "neo.sh";
    private static final String SDK_RELATIVE_CONSOLE_LOCATION = "tools";
    @Parameter(property="sdkInstallPath", readonly=false, required=true)
    public File sdkInstallPath;
    @Parameter(property="relaxOnSdkVersion", defaultValue="false", readonly=false, required=false)
    public boolean relaxOnSdkVersion;
    @Parameter(property="consoleHttpProxyHost", readonly=false, required=false)
    private String consoleHttpProxyHost;
    @Parameter(property="consoleHttpProxyPort", readonly=false, required=false)
    private String consoleHttpProxyPort;
    @Parameter(property="consoleHttpProxyUser", readonly=false, required=false)
    private String consoleHttpProxyUser;
    @Parameter(property="consoleHttpProxyPassword", readonly=false, required=false)
    private String consoleHttpProxyPassword;
    @Parameter(property="consoleHttpNonProxyHosts", readonly=false, required=false)
    private String consoleHttpNonProxyHosts;
    @Parameter(property="consoleHttpsProxyHost", readonly=false, required=false)
    private String consoleHttpsProxyHost;
    @Parameter(property="consoleHttpsProxyPort", readonly=false, required=false)
    private String consoleHttpsProxyPort;
    @Parameter(property="consoleHttpsProxyUser", readonly=false, required=false)
    private String consoleHttpsProxyUser;
    @Parameter(property="consoleHttpsProxyPassword", readonly=false, required=false)
    private String consoleHttpsProxyPassword;
    @Parameter(property="consoleRetryCount", defaultValue="0", readonly=false, required=false)
    private int consoleRetryCount;
    @Parameter(property="consoleArguments", readonly=false, required=false)
    public String consoleArguments;
    @Parameter(property="consoleOutputPropertyPrefix", readonly=false, required=false)
    public String consoleOutputPropertyPrefix;
    @Parameter(property="consoleOutputPropertyDump", defaultValue="true", readonly=false, required=false)
    public boolean consoleOutputPropertyDump;
    @Parameter(property="skip", defaultValue="false", readonly=false, required=false)
    public boolean skip;
    @Parameter(property="failOnError", defaultValue="true", readonly=false, required=false)
    public boolean failOnError;
    @Parameter(defaultValue="${mojoExecution}", readonly=true, required=true)
    private MojoExecution mojoExecution;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    public MavenProject project;
    private StreamReader outStreamReader;
    private StreamReader errStreamReader;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void run(String command) throws MojoExecutionException {
        if (!this.skip) {
            try {
                this.checkSdkPresence();
                this.checkSdkVersion();
                if (this.isStructuredOutputEnabled()) {
                    command = this.mixInArg(command, "--output", "json");
                }
                command = AbstractConsoleCommandMojo.appendArgs(command, this.consoleArguments);
                command = AbstractConsoleCommandMojo.removeLineBreaksAndTrim(command);
                int returnCode = -1;
                int retryNo = 0;
                do {
                    if (retryNo == 0) continue;
                    this.getLog().warn((CharSequence)("Command returned error code " + returnCode + ". Retrying now."));
                } while ((returnCode = this.startProcess(command).waitFor()) != 0 && retryNo++ < this.consoleRetryCount);
                if (returnCode != 0 && this.failOnError) {
                    if (!this.isStructuredOutputEnabled()) throw new MojoExecutionException("Command (" + AbstractConsoleCommandMojo.hidePassword(command) + ") returned error code " + returnCode + " (see above for more information).");
                    this.getLog().error((CharSequence)this.outStreamReader.getBuffer());
                    this.getLog().error((CharSequence)this.errStreamReader.getBuffer());
                    throw new MojoExecutionException("Command (" + AbstractConsoleCommandMojo.hidePassword(command) + ") returned error code " + returnCode + " (see above for more information).");
                }
                if (!this.isStructuredOutputEnabled()) return;
                if (this.outStreamReader.getReadException() != null) {
                    throw new RuntimeException("Error while reading: ", this.outStreamReader.getReadException());
                }
                if (this.errStreamReader.getReadException() != null) {
                    throw new RuntimeException("Error while reading: ", this.errStreamReader.getReadException());
                }
                if (!this.errStreamReader.getBuffer().isEmpty()) {
                    throw new RuntimeException("Error while reading: " + this.errStreamReader.getBuffer());
                }
                this.setProperties(AbstractConsoleCommandMojo.parseConsoleOutput(this.outStreamReader.getBuffer(), this.consoleOutputPropertyPrefix), this.project.getProperties());
                return;
            }
            catch (Exception exception) {
                throw new MojoExecutionException(exception.getMessage(), exception);
            }
        } else {
            this.getLog().info((CharSequence)("Skipping execution of command (" + AbstractConsoleCommandMojo.hidePassword(command) + ")."));
        }
    }

    protected String mixInArg(String command, String argName, String argValue) {
        return AbstractConsoleCommandMojo.mixInArg(command, this.consoleArguments, argName, argValue);
    }

    protected void checkConfigurationForUnmappedParameters(Map<String, String> alternateParameterToConfigKeyMap) {
        try {
            PluginDescriptor mojoPluginDescriptor = this.mojoExecution.getMojoDescriptor().getPluginDescriptor();
            String pluginGA = mojoPluginDescriptor.getGroupId() + ":" + mojoPluginDescriptor.getArtifactId();
            Plugin plugin = (Plugin)this.project.getBuild().getPluginsAsMap().get(pluginGA);
            PluginExecution pluginExecution = (PluginExecution)plugin.getExecutionsAsMap().get(this.mojoExecution.getExecutionId());
            Xpp3Dom pluginCfg = (Xpp3Dom)pluginExecution.getConfiguration();
            this.getLog().debug((CharSequence)("Plugin " + pluginGA + " configuration: " + pluginCfg));
            for (Xpp3Dom cfgChild : pluginCfg.getChildren()) {
                String name = cfgChild.getName();
                String configName = alternateParameterToConfigKeyMap.get(name);
                if (configName == null || name.equals(configName)) continue;
                this.getLog().warn((CharSequence)("Found plugin execution configuration parameter " + name + ". Did you mean " + configName + "?"));
            }
        }
        catch (Exception e) {
            this.getLog().debug((CharSequence)"Failed to check for plugin execution configuration parameter hint", (Throwable)e);
        }
    }

    private void checkSdkPresence() throws MojoExecutionException {
        if (!SdkVersion.isPresent(this.sdkInstallPath) || !new File(this.sdkInstallPath, SDK_RELATIVE_CONSOLE_LOCATION).exists()) {
            throw new MojoExecutionException("No SDK installed in " + this.sdkInstallPath);
        }
    }

    private void checkSdkVersion() throws Exception {
        try {
            String pluginVersion = this.mojoExecution.getMojoDescriptor().getPluginDescriptor().getVersion();
            String sdkVersion = SdkVersion.read(this.sdkInstallPath);
            if (!pluginVersion.equals(sdkVersion)) {
                this.getLog().warn((CharSequence)("Plugin version (" + pluginVersion + ") and SDK version (" + sdkVersion + ") do not match. The plugin may not work properly."));
                throw new MojoExecutionException("Aborting execution due to plugin and SDK version mismatch (plugin was configured to be strict on SDK version)");
            }
        }
        catch (Exception exception) {
            if (this.relaxOnSdkVersion) {
                this.getLog().warn((CharSequence)"Ignoring issues with plugin and SDK versions (plugin was configured to relax on SDK version)");
            }
            throw exception;
        }
    }

    private Process startProcess(String command) throws IOException {
        File consoleLocation = new File(this.sdkInstallPath, SDK_RELATIVE_CONSOLE_LOCATION).getCanonicalFile();
        ProcessBuilder processBuilder = AbstractConsoleCommandMojo.createProcessBuilder(consoleLocation, command, this.consoleHttpProxyHost, this.consoleHttpProxyPort, this.consoleHttpProxyUser, this.consoleHttpProxyPassword, this.consoleHttpNonProxyHosts, this.consoleHttpsProxyHost, this.consoleHttpsProxyPort, this.consoleHttpsProxyUser, this.consoleHttpsProxyPassword, OsName.getOsName());
        this.getLog().debug((CharSequence)("About to run command " + AbstractConsoleCommandMojo.hidePassword(AbstractConsoleCommandMojo.turnCommandListIntoString(processBuilder.command())) + " in " + consoleLocation + " with " + AbstractConsoleCommandMojo.extractProxySettings(processBuilder.environment())));
        Process process = processBuilder.start();
        if (this.isStructuredOutputEnabled()) {
            this.outStreamReader = new StreamReader(process.getInputStream());
            this.errStreamReader = new StreamReader(process.getErrorStream());
        } else {
            this.outStreamReader = new StreamReader(process.getInputStream(), StreamReader.TYPE.LOG_AS_INFO, this.getLog());
            this.errStreamReader = new StreamReader(process.getErrorStream(), StreamReader.TYPE.LOG_AS_ERROR, this.getLog());
        }
        this.outStreamReader.start();
        this.errStreamReader.start();
        return process;
    }

    private void setProperties(Map<String, String> propertyMap, Properties properties) {
        ArrayList<String> propertyMapKeys = new ArrayList<String>(propertyMap.keySet());
        Collections.sort(propertyMapKeys);
        for (String key : propertyMapKeys) {
            Object oldValue;
            String value = propertyMap.get(key);
            if (value != null) {
                oldValue = properties.put(key, value);
                if (oldValue != null) {
                    this.logPropertyInformation("Property " + key + " replaced with " + (value.isEmpty() ? "empty string" : value));
                    continue;
                }
                this.logPropertyInformation("Property " + key + " set to " + (value.isEmpty() ? "empty string" : value));
                continue;
            }
            oldValue = properties.remove(key);
            if (oldValue == null) continue;
            this.logPropertyInformation("Property " + key + " removed");
        }
    }

    private void logPropertyInformation(String msg) {
        if (this.consoleOutputPropertyDump) {
            this.getLog().info((CharSequence)msg);
        } else {
            this.getLog().debug((CharSequence)msg);
        }
    }

    private boolean isStructuredOutputEnabled() {
        return AbstractConsoleCommandMojo.isSet(this.consoleOutputPropertyPrefix);
    }

    protected static boolean isSet(String parameter) {
        return parameter != null && !parameter.trim().isEmpty();
    }

    static ProcessBuilder createProcessBuilder(File consoleLocation, String command, String consoleHttpProxyHost, String consoleHttpProxyPort, String consoleHttpProxyUser, String consoleHttpProxyPassword, String consoleHttpNonProxyHosts, String consoleHttpsProxyHost, String consoleHttpsProxyPort, String consoleHttpsProxyUser, String consoleHttpsProxyPassword, OsName osName) {
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        processBuilder.directory(consoleLocation);
        switch (osName) {
            case WINDOWS: {
                processBuilder.command().add(CONSOLE_SHELL_WINDOWS);
                processBuilder.command().addAll(AbstractConsoleCommandMojo.splitArgs("/c neo.bat " + command));
                AbstractConsoleCommandMojo.ignorePutOrRemove("HTTP_PROXY_HOST", consoleHttpProxyHost, processBuilder.environment());
                AbstractConsoleCommandMojo.ignorePutOrRemove("HTTP_PROXY_PORT", consoleHttpProxyPort, processBuilder.environment());
                AbstractConsoleCommandMojo.ignorePutOrRemove("HTTP_PROXY_USER", consoleHttpProxyUser, processBuilder.environment());
                AbstractConsoleCommandMojo.ignorePutOrRemove("HTTP_PROXY_PASSWORD", consoleHttpProxyPassword, processBuilder.environment());
                AbstractConsoleCommandMojo.ignorePutOrRemove("HTTP_NON_PROXY_HOSTS", consoleHttpNonProxyHosts, processBuilder.environment());
                AbstractConsoleCommandMojo.ignorePutOrRemove("HTTPS_PROXY_HOST", consoleHttpsProxyHost, processBuilder.environment());
                AbstractConsoleCommandMojo.ignorePutOrRemove("HTTPS_PROXY_PORT", consoleHttpsProxyPort, processBuilder.environment());
                AbstractConsoleCommandMojo.ignorePutOrRemove("HTTPS_PROXY_USER", consoleHttpsProxyUser, processBuilder.environment());
                AbstractConsoleCommandMojo.ignorePutOrRemove("HTTPS_PROXY_PASSWORD", consoleHttpsProxyPassword, processBuilder.environment());
                AbstractConsoleCommandMojo.ignorePutOrRemove("HTTPS_NON_PROXY_HOSTS", consoleHttpNonProxyHosts, processBuilder.environment());
                break;
            }
            case LINUX: 
            case MAC: {
                processBuilder.command().add(CONSOLE_SHELL_UNIX);
                processBuilder.command().addAll(AbstractConsoleCommandMojo.splitArgs("neo.sh " + command));
                StringBuilder httpProxy = null;
                if (consoleHttpProxyHost != null) {
                    httpProxy = new StringBuilder();
                    if (!consoleHttpProxyHost.isEmpty()) {
                        httpProxy.append("http://");
                        if (consoleHttpProxyUser != null && !consoleHttpProxyUser.isEmpty() && consoleHttpProxyPassword != null && !consoleHttpProxyPassword.isEmpty()) {
                            httpProxy.append(consoleHttpProxyUser);
                            httpProxy.append(":");
                            httpProxy.append(consoleHttpProxyPassword);
                            httpProxy.append("@");
                        }
                        httpProxy.append(consoleHttpProxyHost);
                        if (consoleHttpProxyPort != null && !consoleHttpProxyPort.isEmpty()) {
                            httpProxy.append(":");
                            httpProxy.append(consoleHttpProxyPort);
                        }
                        httpProxy.append("/");
                    }
                }
                AbstractConsoleCommandMojo.ignorePutOrRemove("http_proxy", httpProxy == null ? null : httpProxy.toString(), processBuilder.environment());
                StringBuilder httpsProxy = null;
                if (consoleHttpsProxyHost != null) {
                    httpsProxy = new StringBuilder();
                    if (!consoleHttpsProxyHost.isEmpty()) {
                        httpsProxy.append("https://");
                        if (consoleHttpsProxyUser != null && !consoleHttpsProxyUser.isEmpty() && consoleHttpsProxyPassword != null && !consoleHttpsProxyPassword.isEmpty()) {
                            httpsProxy.append(consoleHttpsProxyUser);
                            httpsProxy.append(":");
                            httpsProxy.append(consoleHttpsProxyPassword);
                            httpsProxy.append("@");
                        }
                        httpsProxy.append(consoleHttpsProxyHost);
                        if (consoleHttpsProxyPort != null && !consoleHttpsProxyPort.isEmpty()) {
                            httpsProxy.append(":");
                            httpsProxy.append(consoleHttpsProxyPort);
                        }
                        httpsProxy.append("/");
                    }
                }
                AbstractConsoleCommandMojo.ignorePutOrRemove("https_proxy", httpsProxy == null ? null : httpsProxy.toString(), processBuilder.environment());
                StringBuilder noProxy = null;
                if (consoleHttpNonProxyHosts != null) {
                    noProxy = new StringBuilder();
                    if (!consoleHttpNonProxyHosts.isEmpty()) {
                        noProxy.append(consoleHttpNonProxyHosts);
                    }
                }
                AbstractConsoleCommandMojo.ignorePutOrRemove("no_proxy", noProxy == null ? null : noProxy.toString(), processBuilder.environment());
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported operating system.");
            }
        }
        return processBuilder;
    }

    static void ignorePutOrRemove(String key, String value, Map<String, String> map) {
        if (value != null) {
            if (!value.isEmpty()) {
                map.put(key, value);
            } else {
                map.remove(key);
            }
        }
    }

    static String mixInArg(String command, String consoleArguments, String argName, String argValue) {
        HashSet<String> args = new HashSet<String>(AbstractConsoleCommandMojo.splitArgs(AbstractConsoleCommandMojo.appendArgs(command, consoleArguments)));
        if (!args.contains(argName)) {
            return AbstractConsoleCommandMojo.insertArgsBeforeOtherArgs(command, AbstractConsoleCommandMojo.appendArgs(argName, argValue));
        }
        return command;
    }

    static String insertArgsBeforeOtherArgs(String argLine, String argsToBeInsertedBeforeOtherArgs) {
        if (argsToBeInsertedBeforeOtherArgs != null && !argsToBeInsertedBeforeOtherArgs.isEmpty()) {
            int insertPos = argLine.indexOf(32);
            if (insertPos == -1) {
                insertPos = argLine.length();
            }
            return argLine.substring(0, insertPos) + " " + argsToBeInsertedBeforeOtherArgs + argLine.substring(insertPos);
        }
        return argLine;
    }

    static String appendArgs(String argLine, String argsToBeAppended) {
        if (argsToBeAppended != null && !argsToBeAppended.isEmpty()) {
            return argLine + " " + argsToBeAppended;
        }
        return argLine;
    }

    static String removeLineBreaksAndTrim(String argLine) {
        return argLine.replaceAll("\r\n|\r|\n", " ").trim();
    }

    static List<String> splitArgs(String argLine) {
        ArrayList<String> arguments = new ArrayList<String>();
        Pattern pattern = Pattern.compile("[^\\s\"']+|\"([^\"]*)\"|'([^']*)'");
        Matcher matcher = pattern.matcher(argLine);
        while (matcher.find()) {
            arguments.add(matcher.group());
        }
        return arguments;
    }

    static String turnCommandListIntoString(List<String> commandList) {
        StringBuilder sb = new StringBuilder();
        for (String commandSegment : commandList) {
            if (sb.length() != 0) {
                sb.append(" ");
            }
            sb.append(commandSegment);
        }
        return sb.toString();
    }

    static String extractProxySettings(Map<String, String> environment) {
        StringBuilder sb = new StringBuilder();
        for (String key : environment.keySet()) {
            if (!key.toLowerCase().contains("proxy")) continue;
            if (sb.length() != 0) {
                sb.append(", ");
            }
            sb.append(key);
            sb.append("=");
            sb.append(environment.get(key));
        }
        if (sb.length() == 0) {
            sb.append("no proxy");
        }
        return sb.toString();
    }

    static String hidePassword(String command) {
        if (command != null) {
            int indexOfPasswordParameterBegin = 0;
            while ((indexOfPasswordParameterBegin = command.toLowerCase().indexOf("password ", indexOfPasswordParameterBegin)) >= 0) {
                int indexOfPasswordValueBegin;
                for (indexOfPasswordValueBegin = indexOfPasswordParameterBegin += "password ".length(); indexOfPasswordValueBegin < command.length() && command.charAt(indexOfPasswordValueBegin) == ' '; ++indexOfPasswordValueBegin) {
                }
                if (indexOfPasswordValueBegin >= command.length()) continue;
                int indexOfPasswordValueEnd = command.indexOf(" ", indexOfPasswordValueBegin);
                if (indexOfPasswordValueEnd > 0) {
                    command = command.substring(0, indexOfPasswordValueBegin) + "***" + command.substring(indexOfPasswordValueEnd);
                    continue;
                }
                command = command.substring(0, indexOfPasswordValueBegin) + "***";
            }
        }
        return command;
    }

    static Map<String, String> parseConsoleOutput(String consoleOutput, String propertyPrefix) {
        HashMap<String, String> propertyMap = new HashMap<String, String>();
        try {
            JsonElement jsonElement = new JsonParser().parse(consoleOutput);
            AbstractConsoleCommandMojo.parseJsonObject(jsonElement, propertyPrefix, propertyMap);
        }
        catch (Exception exception) {
            throw new RuntimeException("Failed to parse command console output (\"" + consoleOutput.trim() + "\")!", exception);
        }
        return propertyMap;
    }

    static void parseJsonObject(JsonElement jsonElement, String propertyKey, Map<String, String> propertyMap) {
        if (jsonElement.isJsonObject()) {
            for (Map.Entry entry : ((JsonObject)jsonElement).entrySet()) {
                AbstractConsoleCommandMojo.parseJsonObject((JsonElement)entry.getValue(), propertyKey + "." + (String)entry.getKey(), propertyMap);
            }
        } else if (jsonElement.isJsonArray()) {
            int i = 0;
            for (JsonElement entry : (JsonArray)jsonElement) {
                AbstractConsoleCommandMojo.parseJsonObject(entry, propertyKey + ".value" + i++, propertyMap);
            }
        } else if (jsonElement.isJsonPrimitive()) {
            propertyMap.put(propertyKey, jsonElement.getAsString().trim());
        } else if (jsonElement.isJsonNull()) {
            propertyMap.put(propertyKey, null);
        } else {
            throw new RuntimeException("Unsupported json element type!");
        }
    }
}

