/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.sdk.cmd.mojo;

import com.sap.core.sdk.cmd.mojo.AbstractConsoleCommandMojo;
import com.sap.core.sdk.cmd.mojo.SdkVersion;
import java.io.File;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.archiver.manager.NoSuchArchiverException;
import org.codehaus.plexus.components.io.fileselectors.FileSelector;
import org.codehaus.plexus.components.io.fileselectors.IncludeExcludeFileSelector;

@Mojo(name="install-sdk", requiresProject=false, threadSafe=false)
public class InstallSdkMojo
extends AbstractMojo {
    @Parameter(property="sdkInstallPath", readonly=false, required=true)
    public File sdkInstallPath;
    @Parameter(property="sdkGroupId", readonly=false, required=false)
    private String sdkGroupId;
    @Parameter(property="sdkArtifactId", readonly=false, required=false)
    private String sdkArtifactId;
    @Parameter(property="sdkVersion", readonly=false, required=false)
    public String sdkVersion;
    @Parameter(property="sdkType", defaultValue="zip", readonly=false, required=false)
    private String sdkType;
    @Parameter(property="sdkClassifier", defaultValue="", readonly=false, required=false)
    private String sdkClassifier;
    @Parameter(property="includes", defaultValue="*.*,add-ons/**,repository/**,tools/**", readonly=false, required=false)
    public String includes;
    @Parameter(property="excludes", defaultValue="**/readme.txt,**/samples/**", readonly=false, required=false)
    public String excludes;
    @Parameter(property="force", defaultValue="false", readonly=false, required=false)
    public boolean force;
    @Parameter(property="skip", defaultValue="false", readonly=false, required=false)
    public boolean skip;
    @Parameter(defaultValue="${mojoExecution}", readonly=true, required=true)
    private MojoExecution mojoExecution;
    @Component
    private ArtifactFactory artifactFactory;
    @Component
    private ArtifactResolver artifactResolver;
    @Parameter(defaultValue="${project.remoteArtifactRepositories}", readonly=true, required=true)
    private List<ArtifactRepository> remoteRepositories;
    @Parameter(defaultValue="${localRepository}", readonly=true, required=true)
    private ArtifactRepository localRepository;
    @Component
    protected ArchiverManager archiverManager;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.skip) {
            try {
                PluginDescriptor pluginDescriptor = this.mojoExecution.getMojoDescriptor().getPluginDescriptor();
                if (this.sdkGroupId == null || this.sdkGroupId.isEmpty()) {
                    this.sdkGroupId = pluginDescriptor.getGroupId();
                }
                if (this.sdkArtifactId == null || this.sdkArtifactId.isEmpty()) {
                    this.sdkArtifactId = pluginDescriptor.getArtifactId().replace("-maven-plugin", "-sdk");
                }
                if (this.sdkVersion == null || this.sdkVersion.isEmpty()) {
                    this.sdkVersion = pluginDescriptor.getVersion();
                }
                if (this.isEmptyOrDoesNotExist(this.sdkInstallPath) || this.force) {
                    this.getLog().debug((CharSequence)("Resolving SDK artifact " + this.sdkGroupId + ":" + this.sdkArtifactId + ":" + this.sdkVersion + ":" + this.sdkType + ":" + this.sdkClassifier));
                    Artifact artifact = this.artifactFactory.createArtifactWithClassifier(this.sdkGroupId, this.sdkArtifactId, this.sdkVersion, this.sdkType, this.sdkClassifier);
                    this.artifactResolver.resolve(artifact, this.remoteRepositories, this.localRepository);
                    this.getLog().debug((CharSequence)("Resolved SDK artifact located in " + artifact.getFile().getAbsolutePath()));
                    this.getLog().info((CharSequence)("Installing SAP Cloud Platform SDK version " + this.sdkVersion + " in " + this.sdkInstallPath));
                    long startTime = System.currentTimeMillis();
                    InstallSdkMojo.deleteSDK(this.sdkInstallPath);
                    this.sdkInstallPath.mkdirs();
                    InstallSdkMojo.extract(this.archiverManager, artifact.getFile(), this.includes, this.excludes, this.sdkInstallPath);
                    this.getLog().info((CharSequence)("Installation completed in " + (System.currentTimeMillis() - startTime) / 1000L + " seconds"));
                }
                String containedSdkVersion = SdkVersion.read(this.sdkInstallPath);
                if (this.sdkVersion.equals(containedSdkVersion)) {
                    this.getLog().info((CharSequence)("Nothing to do as requested version " + this.sdkVersion + " has already been installed in " + this.sdkInstallPath));
                }
                String reason = containedSdkVersion != null ? "contains a different SDK version than requested" : "is not an empty folder";
                throw new IllegalStateException(String.format("The provided SDK installation path %s already exists, but %s. Use the force option to delete the install path content before installation.", this.sdkInstallPath, reason));
            }
            catch (Exception exception) {
                throw new MojoExecutionException(exception.getMessage(), exception);
            }
        } else {
            this.getLog().info((CharSequence)"Skipping installation of SAP Cloud Platform SDK.");
        }
    }

    private boolean isEmptyOrDoesNotExist(File sdkInstallPath) {
        if (sdkInstallPath.isDirectory() && sdkInstallPath.listFiles().length == 0) {
            return true;
        }
        return !sdkInstallPath.exists();
    }

    private static void deleteSDK(File sdkInstallPath) {
        if (sdkInstallPath.exists()) {
            File sdkVersionFile = new File(sdkInstallPath, "sdk.version");
            if (sdkVersionFile.exists()) {
                InstallSdkMojo.deleteFileOrFolder(sdkVersionFile);
            }
            InstallSdkMojo.deleteFileOrFolder(sdkInstallPath);
        }
    }

    private static void deleteFileOrFolder(File file) {
        if (file.isDirectory()) {
            for (File containedFile : file.listFiles()) {
                InstallSdkMojo.deleteFileOrFolder(containedFile);
            }
        }
        if (!file.delete()) {
            throw new RuntimeException("Failed to delete " + file.getAbsolutePath());
        }
    }

    private static void extract(ArchiverManager archiverManager, File zipFile, String includes, String excludes, File destinationFolder) throws NoSuchArchiverException {
        UnArchiver unArchiver = archiverManager.getUnArchiver(zipFile);
        unArchiver.setSourceFile(zipFile);
        unArchiver.setDestDirectory(destinationFolder);
        IncludeExcludeFileSelector[] fileSelectors = new IncludeExcludeFileSelector[]{new IncludeExcludeFileSelector()};
        if (AbstractConsoleCommandMojo.isSet(excludes)) {
            fileSelectors[0].setExcludes(excludes.split(","));
        }
        if (AbstractConsoleCommandMojo.isSet(includes)) {
            fileSelectors[0].setIncludes(includes.split(","));
        }
        unArchiver.setFileSelectors((FileSelector[])fileSelectors);
        unArchiver.extract();
    }
}

