/*
 * Created on 2013.09.18.
 * 
 * Copyright 2013 progos.hu All rights reserved. PROGOS
 * PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 * Author: arpadtamasi
 * $URL$
 * $Rev$
 * $Author$
 * $Date$
 * $Id$
 *
 */

package com.samebug.notifier;

import com.samebug.notifier.core.IConfiguration;
import com.samebug.notifier.core.SamebugAsyncNotifier;
import com.samebug.notifier.core.exceptions.SamebugCapturedException;

import java.lang.Thread.UncaughtExceptionHandler;

/**
 * An uncaught exception handler, which sends the exceptions to Samebug.
 *
 * @author poroszd
 */
public class SamebugUncaughtExceptionHandler implements UncaughtExceptionHandler {
    private final UncaughtExceptionHandler defaultHandler;
    private final SamebugAsyncNotifier notifier;

    public SamebugUncaughtExceptionHandler(final IConfiguration config, final UncaughtExceptionHandler handler) {
        assert (config != null);
        assert (handler != null);
        this.notifier = new SamebugAsyncNotifier(config);
        this.defaultHandler = handler;
    }

    public void uncaughtException(final Thread t, final Throwable e) {
        notifier.notify("Uncaught exception", e);
        defaultHandler.uncaughtException(t, e);

    }
}

class DefaultUncaughtExceptionHandler implements UncaughtExceptionHandler {
    public void uncaughtException(final Thread t, final Throwable e) {
        throw new SamebugCapturedException("Unhandled exception in thread " + t.getId(), e);
    }
}
