/*
 * Decompiled with CFR 0.152.
 */
package com.samebug.notifier;

import com.samebug.notifier.ConfigurationFactory;
import com.samebug.notifier.DefaultUncaughtExceptionHandler;
import com.samebug.notifier.SamebugUncaughtExceptionHandler;
import com.samebug.notifier.core.IConfiguration;
import com.samebug.notifier.core.INotifier;
import com.samebug.notifier.core.IResponse;
import com.samebug.notifier.core.SamebugNotifier;
import com.samebug.notifier.core.exceptions.BadConfigFile;
import com.samebug.notifier.core.exceptions.BadHelpMode;
import com.samebug.notifier.core.exceptions.BadServerAddress;
import com.samebug.notifier.core.exceptions.MultipleConfigFileException;
import com.samebug.notifier.core.exceptions.NoConfigFileException;
import com.samebug.notifier.core.exceptions.NotifierException;
import com.samebug.notifier.core.proxy.ThrowableProxy;
import java.util.Date;

public class Samebug {
    private static boolean initialized = false;
    private static INotifier notifier;

    public static void handleUncaughtExceptions() throws NoConfigFileException, MultipleConfigFileException, BadConfigFile, BadHelpMode, BadServerAddress {
        Samebug.handleUncaughtExceptions(ConfigurationFactory.fromDefault());
    }

    public static void handleUncaughtExceptions(String applicationKey) throws BadHelpMode {
        Samebug.handleUncaughtExceptions(ConfigurationFactory.fromAppKey(applicationKey));
    }

    public static void handleUncaughtExceptions(IConfiguration config) {
        SamebugUncaughtExceptionHandler handler = new SamebugUncaughtExceptionHandler(config, Samebug.getCurrentHandler());
        Thread.setDefaultUncaughtExceptionHandler(handler);
    }

    private static Thread.UncaughtExceptionHandler getCurrentHandler() {
        Thread.UncaughtExceptionHandler handler = Thread.getDefaultUncaughtExceptionHandler();
        if (handler == null) {
            return new DefaultUncaughtExceptionHandler();
        }
        return handler;
    }

    public static synchronized void init() throws NoConfigFileException, MultipleConfigFileException, BadConfigFile, BadHelpMode, BadServerAddress {
        if (!initialized) {
            Samebug.init(ConfigurationFactory.fromDefault());
        }
    }

    public static synchronized void init(String applicationKey) throws BadHelpMode {
        if (!initialized) {
            Samebug.init(ConfigurationFactory.fromAppKey(applicationKey));
        }
    }

    public static synchronized void init(IConfiguration config) {
        if (!initialized) {
            notifier = new SamebugNotifier(config);
            initialized = true;
        }
    }

    public static IResponse notify(String message, Throwable throwable) throws NotifierException {
        if (!initialized) {
            throw new IllegalStateException("Samebug not initialized");
        }
        return notifier.notify(message, throwable);
    }

    public static IResponse notify(String message, Throwable throwable, Date timestamp) throws NotifierException {
        if (!initialized) {
            throw new IllegalStateException("Samebug not initialized");
        }
        return notifier.notify(message, throwable, timestamp);
    }

    public static IResponse notify(String message, ThrowableProxy throwableProxy) throws NotifierException {
        if (!initialized) {
            throw new IllegalStateException("Samebug not initialized");
        }
        return notifier.notify(message, throwableProxy);
    }

    public static IResponse notify(String message, ThrowableProxy throwableProxy, Date timestamp) throws NotifierException {
        if (!initialized) {
            throw new IllegalStateException("Samebug not initialized");
        }
        return notifier.notify(message, throwableProxy, timestamp);
    }
}

