package com.samebug.notifier.jboss;

import com.samebug.notifier.ConfigurationFactory;
import com.samebug.notifier.core.IConfiguration;
import com.samebug.notifier.core.SamebugAsyncNotifier;

import java.util.Date;
import java.util.Properties;
import java.util.logging.Handler;
import java.util.logging.LogRecord;

public class SamebugHandler extends Handler {

    private SamebugAsyncNotifier notifier;
    private Properties properties;

    public SamebugHandler() {
        super();
        notifier = null;
        properties = new Properties();
    }

    public void publish(LogRecord record) {
        if (notifier == null) {
            configure();
        }
        if (record.getThrown() != null) {
            notifier.notify(record.getMessage(), record.getThrown(), new Date());
        }
    }

    public void flush() {
        // TODO: buffer
    }

    public void close() throws SecurityException {
        // TODO: close connection
    }

    public void setAppKey(String appKey) {
        properties.put(ConfigurationFactory.K_APP_KEY, appKey);
    }

    public void setVersion(String version) {
        properties.put(ConfigurationFactory.K_VERSION, version);
    }

    public void setServerURL(String recorderURL) {
        properties.put(ConfigurationFactory.K_RECORDER_URL, recorderURL);
    }

    public void setDebug(String debug) {
        properties.put(ConfigurationFactory.K_DEBUG, debug);
    }

    public void setUIURL(String uiURL) {
        properties.put(ConfigurationFactory.K_UI_URL, uiURL);
    }

    public void setHelpMode(String helpMode) {
        properties.put(ConfigurationFactory.K_HELP_MODE, helpMode);
    }

    private void configure() {
        IConfiguration config = ConfigurationFactory.fromProperties(properties);
        notifier = new SamebugAsyncNotifier(config);
    }
}
