/*
 * Created on 2013.09.02.
 * 
 * Copyright 2013 progos.hu All rights reserved. PROGOS
 * PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 * Author: arpadtamasi
 * $URL$
 * $Rev$
 * $Author$
 * $Date$
 * $Id$
 *
 */

package com.samebug.notifier.log4j;

import com.samebug.notifier.ConfigurationFactory;
import com.samebug.notifier.core.IConfiguration;
import com.samebug.notifier.core.SamebugAsyncNotifier;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.spi.LoggingEvent;

import java.util.Date;

public class SamebugAppender extends AppenderSkeleton {
    private final SamebugAsyncNotifier notifier;

    public SamebugAppender() {
        this(ConfigurationFactory.fromDefault());
    }

    public SamebugAppender(final IConfiguration config) {
        super();
        notifier = new SamebugAsyncNotifier(config);
    }

    public void close() {
    }

    public boolean requiresLayout() {
        return false;
    }

    @Override
    protected void append(final LoggingEvent event) {
        if (event.getThrowableInformation() != null) {
            String message  = event.getMessage() == null ? null : String.valueOf(event.getMessage());
            Throwable throwable = event.getThrowableInformation().getThrowable();
            notifier.notify(message, throwable, new Date());
        }
    }
}
