package com.samebug.notifier.jul;

import java.util.Date;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;

import com.samebug.notifier.ConfigurationFactory;
import com.samebug.notifier.IReporter;
import com.samebug.notifier.StreamReporter;
import com.samebug.notifier.core.IConfiguration;
import com.samebug.notifier.core.IResponse;
import com.samebug.notifier.core.SamebugNotifier;
import com.samebug.notifier.core.exceptions.NotifierException;
import com.samebug.notifier.core.exceptions.RecorderError;

public class SamebugHandler extends Handler {

    private final SamebugNotifier notifier;
    private final IReporter reporter;

    public SamebugHandler() {
        this(ConfigurationFactory.fromDefault());
    }

    public SamebugHandler(final IConfiguration config) {
        super();
        reporter = new StreamReporter(config);
        notifier = new SamebugNotifier(config);
    }

    public void publish(LogRecord record) {
        if (record.getThrown() != null && record.getLevel() == Level.SEVERE) {
            try {
                IResponse resp = notifier.notify(record.getMessage(), record.getThrown(), new Date());
                reporter.handleResponse(resp);
            } catch (final RecorderError e) {
                reporter.handleRecorderError(e);
            } catch (final NotifierException e) {
                reporter.handleNotifierException(e);
            }
        }
    }

    public void flush() {
        // TODO: buffer
    }

    public void close() throws SecurityException {
        // TODO: close connection
    }
}
