/*
 * Decompiled with CFR 0.152.
 */
package com.samebug.notifier.jul;

import com.samebug.notifier.ConfigurationFactory;
import com.samebug.notifier.IReporter;
import com.samebug.notifier.StreamReporter;
import com.samebug.notifier.core.IConfiguration;
import com.samebug.notifier.core.IResponse;
import com.samebug.notifier.core.SamebugNotifier;
import com.samebug.notifier.core.exceptions.NotifierException;
import com.samebug.notifier.core.exceptions.RecorderError;
import java.util.Date;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class SamebugHandler
extends Handler {
    private final SamebugNotifier notifier;
    private final IReporter reporter;

    public SamebugHandler() {
        this(ConfigurationFactory.fromDefault());
    }

    public SamebugHandler(IConfiguration config) {
        this.reporter = new StreamReporter(config);
        this.notifier = new SamebugNotifier(config);
    }

    public void publish(LogRecord record) {
        if (record.getThrown() != null && record.getLevel() == Level.SEVERE) {
            try {
                IResponse resp = this.notifier.notify(record.getMessage(), record.getThrown(), new Date());
                this.reporter.handleResponse(resp);
            }
            catch (RecorderError e) {
                this.reporter.handleRecorderError(e);
            }
            catch (NotifierException e) {
                this.reporter.handleNotifierException(e);
            }
        }
    }

    public void flush() {
    }

    public void close() throws SecurityException {
    }
}

