/*
 * Decompiled with CFR 0.152.
 */
package com.ruijc.util;

import com.ruijc.Href;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtils {
    public static final String HTML_A_TAG_PATTERN = "(?i)<a([^>]+)>(.+?)</a>";
    public static final String HTML_A_HREF_TAG_PATTERN = "\\s*(?i)href\\s*=\\s*(\"([^\"]*\")|'[^']*'|([^'\">\\s]+))";
    private static final Pattern a = Pattern.compile("(?i)<a([^>]+)>(.+?)</a>");
    private static final Pattern b = Pattern.compile("\\s*(?i)href\\s*=\\s*(\"([^\"]*\")|'[^']*'|([^'\">\\s]+))");
    private static Matcher c;
    private static Matcher d;

    public static String getNicknameFromEmail(String string) {
        int n = string.indexOf(64);
        if (-1 != n) {
            return string.substring(0, n);
        }
        return string;
    }

    public static String emailServer(String string) {
        int n = string.indexOf(64);
        if (-1 != n) {
            return "http://mail." + string.substring(n + 1);
        }
        return string;
    }

    public static boolean isChinese(char c) {
        Character.UnicodeBlock unicodeBlock = Character.UnicodeBlock.of(c);
        return unicodeBlock == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS || unicodeBlock == Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS || unicodeBlock == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A || unicodeBlock == Character.UnicodeBlock.GENERAL_PUNCTUATION || unicodeBlock == Character.UnicodeBlock.CJK_SYMBOLS_AND_PUNCTUATION || unicodeBlock == Character.UnicodeBlock.HALFWIDTH_AND_FULLWIDTH_FORMS;
    }

    public static boolean isMessyCode(String object) {
        float f;
        Pattern pattern = Pattern.compile("\\s*|\t*|\r*|\n*");
        object = pattern.matcher((CharSequence)object);
        object = ((Matcher)object).replaceAll("");
        object = ((String)object).replaceAll("\\p{P}", "");
        char[] cArray = ((String)object).trim().toCharArray();
        object = cArray;
        float f2 = cArray.length;
        float f3 = 0.0f;
        for (int i = 0; i < ((Object)object).length; ++i) {
            Object object2 = object[i];
            if (Character.isLetterOrDigit((char)object2) || StringUtils.isChinese((char)object2)) continue;
            f3 += 1.0f;
        }
        float f4 = f3 / f2;
        return (double)f > 1.0E-13;
    }

    public static boolean isGBK(String object) {
        object = ((String)object).toCharArray();
        boolean bl = false;
        for (int i = 0; i < ((Object)object).length; ++i) {
            byte[] byArray = ("" + (char)object[i]).getBytes();
            if (byArray.length != 2) continue;
            int[] nArray = new int[2];
            int[] nArray2 = nArray;
            nArray[0] = byArray[0] & 0xFF;
            nArray2[1] = byArray[1] & 0xFF;
            if (nArray2[0] < 129 || nArray2[0] > 254 || nArray2[1] < 64 || nArray2[1] > 254) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public static String read(Reader reader) throws IOException {
        String string;
        reader = new BufferedReader(reader);
        StringBuilder stringBuilder = new StringBuilder();
        while ((string = ((BufferedReader)reader).readLine()) != null) {
            stringBuilder.append(string);
            stringBuilder.append("\r\n");
        }
        return stringBuilder.toString();
    }

    public static Map<String, String> parseQuery(String stringArray) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (!StringUtils.isBlank((String)stringArray) && (stringArray = stringArray.split("&")) != null && stringArray.length > 0) {
            for (String string : stringArray) {
                if (StringUtils.isBlank(string)) continue;
                String[] stringArray2 = string.split("=");
                hashMap.put(stringArray2[0], stringArray2[1]);
            }
        }
        return hashMap;
    }

    public static String delSpace(String string) {
        if (string == null) {
            return "";
        }
        String string2 = "^[\u3000 ]*";
        String string3 = "[\u3000 ]*$";
        return string.replaceAll(string2, "").replaceAll(string3, "");
    }

    public static String trimEx(String string) {
        if (string == null) {
            return "";
        }
        string = StringUtils.delSpace(string);
        return string.replaceAll("\\s{2,}", " ");
    }

    public static String domain(String object) {
        String string = "";
        if (object == null || "".equals(object)) {
            return "";
        }
        Pattern pattern = Pattern.compile("(?<=http://|\\.)[^.]*?\\.(com|cn|net|org|biz|info|cc|tv)", 2);
        object = pattern.matcher((CharSequence)object);
        while (((Matcher)object).find()) {
            string = ((Matcher)object).group();
        }
        return string;
    }

    public static String substring(String string, int n, char c) {
        CharSequence charSequence = "";
        if (string == null) {
            return charSequence;
        }
        if (string.length() < n) {
            charSequence = new StringBuilder();
            ((StringBuilder)charSequence).append(string);
            for (int i = 0; i < n - string.length(); ++i) {
                ((StringBuilder)charSequence).append("0");
            }
            charSequence = ((StringBuilder)charSequence).toString();
        } else {
            charSequence = string.substring(0, n);
        }
        return charSequence;
    }

    public static String substring(String string, int n, String string2) {
        int n2 = string.length();
        if (n2 <= n) {
            return string.substring(0, n2);
        }
        return string.substring(0, n) + string2;
    }

    public static String substring(String string, int n) {
        return StringUtils.substring(string, n, "...");
    }

    public static String replaceBlank(String object) {
        Object object2 = "";
        if (object != null) {
            object2 = Pattern.compile("\\s*|\t|\r|\n");
            object = ((Pattern)object2).matcher((CharSequence)object);
            object2 = ((Matcher)object).replaceAll("");
        }
        return object2;
    }

    public static String[] list(String string, String string2) {
        if (string != null) {
            return string.split(string2);
        }
        return new String[0];
    }

    public static String[] list(String string) {
        return StringUtils.list(string, ",");
    }

    public static String toString(Object object) {
        if (object == null) {
            return "";
        }
        return object.toString();
    }

    public static String clearHTML(String object) {
        Object object2 = "<script[^>]*?>[\\s\\S]*?<\\/script>";
        String string = "<style[^>]*?>[\\s\\S]*?<\\/style>";
        String string2 = "<[^>]+>";
        object2 = Pattern.compile((String)object2, 2);
        object = ((Pattern)object2).matcher((CharSequence)object);
        object = ((Matcher)object).replaceAll("");
        object2 = Pattern.compile(string, 2);
        object = ((Pattern)object2).matcher((CharSequence)object);
        object = ((Matcher)object).replaceAll("");
        object2 = Pattern.compile(string2, 2);
        object = ((Pattern)object2).matcher((CharSequence)object);
        object = ((Matcher)object).replaceAll("");
        return ((String)object).trim();
    }

    public static boolean isBlank(String string) {
        return string == null || string.isEmpty();
    }

    public static boolean isAnyBlank(String ... stringArray) {
        for (String string : stringArray) {
            if (!StringUtils.isBlank(string)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAllBlank(String ... stringArray) {
        for (String string : stringArray) {
            if (StringUtils.isBlank(string)) continue;
            return false;
        }
        return true;
    }

    public static boolean isAllEndsWith(String string, String ... stringArray) {
        for (String string2 : stringArray) {
            if (string.endsWith(string2)) continue;
            return false;
        }
        return true;
    }

    public static boolean isAnyEndsWith(String string, String ... stringArray) {
        for (String string2 : stringArray) {
            if (!string.endsWith(string2)) continue;
            return true;
        }
        return false;
    }

    public static String toAscii(String object) {
        StringBuilder stringBuilder = new StringBuilder();
        object = ((String)object).getBytes();
        for (int i = 0; i < ((Object)object).length; ++i) {
            if (object[i] < 0) {
                stringBuilder.append((char)(object[i] & 0x7F));
                continue;
            }
            stringBuilder.append('\u0000');
            stringBuilder.append((char)object[i]);
        }
        return stringBuilder.toString();
    }

    public static String fromAscii(String object) {
        int n;
        object = ((String)object).getBytes();
        int n2 = 0;
        int n3 = ((Object)object).length;
        int n4 = 0;
        for (n = 0; n < n3; ++n) {
            if (object[n] != false) continue;
            ++n2;
        }
        byte[] byArray = new byte[n3 - n2];
        for (n = 0; n < n3; ++n) {
            byArray[n4] = object[n] == false ? (byte)object[++n] : (byte)(object[n] | 0x80);
            ++n4;
        }
        object = new String(byArray);
        return object;
    }

    public static List<Href> getHrefs(String string) {
        ArrayList<Href> arrayList = new ArrayList<Href>();
        if (StringUtils.isBlank(string)) {
            return arrayList;
        }
        c = a.matcher(string);
        while (c.find()) {
            string = c.group(1);
            String string2 = c.group(2);
            d = b.matcher(string);
            while (d.find()) {
                string = d.group(1).replaceAll("\"", "").replaceAll("'", "");
                if (StringUtils.isBlank(string)) continue;
                arrayList.add(new Href(string, string2));
            }
        }
        return arrayList;
    }

    public static void parseLink(String iterator, List<Map<String, String>> list) {
        if ((iterator = StringUtils.getHrefs((String)((Object)iterator))) != null && !iterator.isEmpty()) {
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                Href href = (Href)iterator.next();
                String string = href.getLink();
                if (StringUtils.isBlank(string) || -1 != string.indexOf("pan.baidu.com")) continue;
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("url", string);
                hashMap.put("name", href.getText());
                list.add(hashMap);
            }
        }
    }

    public static String interval(String string, String string2, int n) {
        StringBuilder stringBuilder = new StringBuilder();
        if (StringUtils.isBlank(string)) {
            return stringBuilder.toString();
        }
        int n2 = string.length();
        for (int i = 0; i < n2; i += n) {
            int n3 = i + n;
            if (i >= n2) {
                i = n2 - 1;
            }
            if (n3 >= n2) {
                n3 = n2 - 1;
            }
            if (n3 == n2 - 1) {
                stringBuilder.append(string.subSequence(i, n3));
                continue;
            }
            stringBuilder.append(string.subSequence(i, n3));
            stringBuilder.append(string2);
        }
        return stringBuilder.toString();
    }

    public static String interval(String string, int n) {
        return StringUtils.interval(string, "<br/>", n);
    }

    public static String interval(String string, String string2) {
        return StringUtils.interval(string, string2, 30);
    }

    public static String interval(String string) {
        return StringUtils.interval(string, "<br/>", 30);
    }

    public static boolean check(String object, String object2) {
        object2 = Pattern.compile((String)object2);
        object = ((Pattern)object2).matcher((CharSequence)object);
        return ((Matcher)object).find();
    }

    public static boolean check(String string, String ... stringArray) {
        for (String string2 : stringArray) {
            Pattern pattern = Pattern.compile(string2);
            Matcher object = pattern.matcher(string);
            if (!object.find()) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(String string, String string2) {
        return StringUtils.contains(string, string2, ",", ",");
    }

    public static boolean contains(String stringArray, String stringArray2, String string, String string2) {
        if (StringUtils.isBlank((String)stringArray)) {
            return false;
        }
        if (StringUtils.isBlank((String)stringArray2)) {
            return true;
        }
        if ((stringArray = stringArray.split(string)) == null || 0 == stringArray.length) {
            return false;
        }
        if ((stringArray2 = stringArray2.split(string2)) == null || 0 == stringArray2.length) {
            return true;
        }
        for (String string3 : stringArray) {
            String[] stringArray3 = stringArray2;
            int n = stringArray2.length;
            for (int i = 0; i < n; ++i) {
                String string4 = stringArray3[i];
                if (StringUtils.isBlank(string3) || StringUtils.isBlank(string4) || !string3.equals(string4)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean containsAll(String string, String ... stringArray) {
        if (StringUtils.isBlank(string)) {
            return false;
        }
        if (stringArray == null || 0 == stringArray.length) {
            return true;
        }
        for (String string2 : stringArray) {
            if (!string.contains(string2)) break;
        }
        return false;
    }

    public static boolean containsAny(String string, String ... stringArray) {
        boolean bl = false;
        if (StringUtils.isBlank(string)) {
            return false;
        }
        if (stringArray == null || 0 == stringArray.length) {
            return true;
        }
        for (String string2 : stringArray) {
            if (!string.contains(string2)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public static String getString(String ... stringArray) {
        String string2 = "";
        if (stringArray == null || 0 == stringArray.length) {
            return string2;
        }
        for (String string2 : stringArray) {
            String string3;
            string2 = string2;
            if (!StringUtils.isBlank(string3)) break;
        }
        return string2;
    }

    public static boolean contains(List<String> list, String ... stringArray) {
        boolean bl = true;
        if (list == null || list.isEmpty()) {
            return true;
        }
        for (String string : stringArray) {
            bl |= list.contains(string);
        }
        return bl;
    }

    public static boolean containsNCS(List<String> object, String string) {
        boolean bl = false;
        if (object == null || object.isEmpty() || StringUtils.isBlank(string)) {
            return false;
        }
        object = object.iterator();
        while (object.hasNext()) {
            String string2 = (String)object.next();
            if (!string2.toLowerCase().equals(string.toLowerCase())) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public static String stackTrace(Throwable stackTraceElementArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (StackTraceElement stackTraceElement : stackTraceElementArray.getStackTrace()) {
            stringBuilder.append(stackTraceElement.toString());
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    public static String contact(Collection<String> object, String string) {
        CharSequence charSequence = "";
        if (object == null || object.isEmpty()) {
            return charSequence;
        }
        charSequence = new StringBuilder();
        object = object.iterator();
        while (object.hasNext()) {
            String string2 = (String)object.next();
            ((StringBuilder)charSequence).append(string2).append(string);
        }
        charSequence = ((StringBuilder)charSequence).substring(0, ((StringBuilder)charSequence).length() - string.length());
        return charSequence;
    }

    public static String getFilenameFromUrl(String string) {
        int n = string.lastIndexOf("/");
        if (string.substring(n).lastIndexOf(".") == -1) {
            return string;
        }
        if (!"".equals(string.substring(string.lastIndexOf("/") + 1, string.lastIndexOf(".")))) {
            return string.substring(string.lastIndexOf("/") + 1);
        }
        StringUtils.getFilenameFromUrl(string.substring(0, string.lastIndexOf("/")));
        return string;
    }

    public static void main(String[] stringArray) {
        System.err.println("--->" + StringUtils.interval("<a href='www.icoolxue.com'>Href1</a>Content<a href='video.icoolxue.com'>Href2</a>", "<br/>", 3));
    }
}

