/*
 * Decompiled with CFR 0.152.
 */
package com.ruijc.util;

import com.ruijc.util.NumberUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlUtils {
    public static <T> T parseObject(String xml, Class<T> clazz) {
        Object obj;
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{clazz});
            Unmarshaller um = jaxbContext.createUnmarshaller();
            obj = um.unmarshal((InputStream)new ByteArrayInputStream(xml.getBytes("UTF-8")));
        }
        catch (Exception e) {
            obj = null;
        }
        return (T)obj;
    }

    public static <T> String toXml(Object obj, Class<T> clazz) {
        String ret;
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{clazz});
            Marshaller marshaller = context.createMarshaller();
            marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
            StringWriter writer = new StringWriter();
            marshaller.marshal(obj, (Writer)writer);
            ret = writer.toString();
        }
        catch (JAXBException e) {
            ret = "";
        }
        return ret;
    }

    public static String getText(String data, String element) {
        String result = "";
        Pattern pattern = Pattern.compile(XmlUtils.makePattern(element));
        Matcher matcher = pattern.matcher(data);
        if (matcher.find()) {
            result = XmlUtils.getXmlClearText(matcher.group(1));
        }
        return result;
    }

    public static int getInt(String data, String element) {
        String result = "";
        Pattern pattern = Pattern.compile(XmlUtils.makePattern(element));
        Matcher matcher = pattern.matcher(data);
        if (matcher.find()) {
            result = XmlUtils.getXmlClearText(matcher.group(1));
        }
        return NumberUtils.getInt(result);
    }

    public static String getTextX(String data, String path) {
        String result = "";
        String[] elements = path.split("/");
        for (int index = 0; index < elements.length; ++index) {
            if (index != elements.length - 1) {
                data = XmlUtils.getText(data, elements[index]);
                continue;
            }
            result = XmlUtils.getText(data, elements[index]);
        }
        return result;
    }

    public static int getIntX(String data, String path) {
        String result = "";
        String[] elements = path.split("/");
        for (int index = 0; index < elements.length; ++index) {
            if (index != elements.length - 1) {
                data = XmlUtils.getText(data, elements[index]);
                continue;
            }
            result = XmlUtils.getText(data, elements[index]);
        }
        return NumberUtils.getInt(result);
    }

    public static List<String> getTexts(String data, String element) {
        ArrayList<String> textList = new ArrayList<String>();
        Pattern pattern = Pattern.compile(XmlUtils.makePattern(element));
        Matcher matcher = pattern.matcher(data);
        while (matcher.find()) {
            textList.add(XmlUtils.getXmlClearText(matcher.group(1)));
        }
        return textList;
    }

    public static List<String> getTextsX(String data, String path) {
        List<String> textList = new ArrayList<String>();
        String[] elements = path.split("/");
        for (int index = 0; index < elements.length; ++index) {
            if (index != elements.length - 1) {
                data = XmlUtils.getText(data, elements[index]);
                continue;
            }
            textList = XmlUtils.getTexts(data, elements[index]);
        }
        return textList;
    }

    private static String makePattern(String param) {
        StringBuilder sb = new StringBuilder();
        sb.append("<");
        sb.append(param);
        sb.append(">");
        sb.append("(.*?)");
        sb.append("</");
        sb.append(param);
        sb.append(">");
        return sb.toString();
    }

    private static String getXmlClearText(String xml) {
        return xml.replaceAll("\\<\\!\\[CDATA\\[", "").replaceAll("]]>", "");
    }

    public static Map<String, String> convert(String xml) throws Exception {
        xml = XmlUtils.getXmlClearText(xml);
        ByteArrayInputStream is = new ByteArrayInputStream(xml.getBytes("UTF-8"));
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document document = db.parse(is);
        return XmlUtils.createMap(document.getDocumentElement());
    }

    public static Map<String, String> createMap(Node node) {
        HashMap<String, String> map = new HashMap<String, String>();
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node currentNode = nodeList.item(i);
            if (currentNode.hasAttributes()) {
                for (int j = 0; j < currentNode.getAttributes().getLength(); ++j) {
                    Node item = currentNode.getAttributes().item(i);
                    map.put(item.getNodeName(), item.getTextContent());
                }
            }
            if (node.getFirstChild() != null && node.getFirstChild().getNodeType() == 1) {
                map.putAll(XmlUtils.createMap(currentNode));
                continue;
            }
            if (node.getFirstChild().getNodeType() != 3) continue;
            map.put(node.getLocalName(), node.getTextContent());
        }
        return map;
    }

    public static void main(String[] args) {
        String xmlText = "<A><B>1</B></A>";
        System.err.println("--->" + XmlUtils.getTextX(xmlText, "A/B"));
        String xmlTexts = "<items><item>1</item><item>2</item></items>";
        System.err.println("--->" + XmlUtils.getTextsX(xmlTexts, "items/item"));
    }
}

