/*
 * Decompiled with CFR 0.152.
 */
package com.ruijc.util;

import com.ruijc.util.encrypt.AESUtils;
import com.ruijc.util.encrypt.DESUtils;
import com.ruijc.util.encrypt.MD5Utils;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class EncryptUtils {
    private static final String HMAC_SHA1 = "HmacSHA1";

    public static String hmacSHA1(byte[] data, byte[] key) throws InvalidKeyException, NoSuchAlgorithmException {
        SecretKeySpec signingKey = new SecretKeySpec(key, HMAC_SHA1);
        Mac mac = Mac.getInstance(HMAC_SHA1);
        mac.init(signingKey);
        byte[] rawHmac = mac.doFinal(data);
        return EncryptUtils.md5(rawHmac);
    }

    public static String hmacSHA1(String data, String key) throws InvalidKeyException, NoSuchAlgorithmException {
        return EncryptUtils.hmacSHA1(data.getBytes(), key.getBytes());
    }

    public static String md5(String data) {
        return MD5Utils.md5Hex(data);
    }

    public static String md5(byte[] data) {
        return MD5Utils.md5Hex(data);
    }

    public static String desEncrypt(String key, String encrypt) {
        String out;
        try {
            out = DESUtils.encrypt(encrypt, key);
        }
        catch (Exception e) {
            out = "";
        }
        return out;
    }

    public static String desDecrypt(String key, String decrypt) {
        String out;
        try {
            out = DESUtils.decrypt(decrypt, key);
        }
        catch (Exception e) {
            out = "";
        }
        return out;
    }

    public static String aesEncrypt(String key, String encrypt) {
        return AESUtils.encrypt(encrypt, key);
    }

    public static String aesDecrypt(String key, String decrypt) {
        return AESUtils.decrypt(decrypt, key);
    }

    public static String base64Encrypt(String from) {
        return new String(Base64.getEncoder().encode(from.getBytes()));
    }

    public static String base64Decrypt(String from) {
        return new String(Base64.getDecoder().decode(from));
    }
}

