/*
 * Decompiled with CFR 0.152.
 */
package com.ruijc.util;

import com.ruijc.util.encrypt.Base58Utils;
import java.nio.ByteBuffer;
import java.util.Base64;
import java.util.UUID;

public class UUIDUtils {
    public static String uuid() {
        UUID uuid = UUID.randomUUID();
        return uuid.toString();
    }

    public static String base64Uuid() {
        UUID uuid = UUID.randomUUID();
        return UUIDUtils.base64Uuid(uuid);
    }

    public static String base58Uuid() {
        UUID uuid = UUID.randomUUID();
        return UUIDUtils.base58Uuid(uuid);
    }

    private static String base58Uuid(UUID uuid) {
        ByteBuffer bb = ByteBuffer.wrap(new byte[16]);
        bb.putLong(uuid.getMostSignificantBits());
        bb.putLong(uuid.getLeastSignificantBits());
        return Base58Utils.encode(bb.array());
    }

    private static String base64Uuid(UUID uuid) {
        ByteBuffer bb = ByteBuffer.wrap(new byte[16]);
        bb.putLong(uuid.getMostSignificantBits());
        bb.putLong(uuid.getLeastSignificantBits());
        return Base64.getUrlEncoder().encodeToString(bb.array());
    }

    public static String compress(String uuidString) {
        UUID uuid = UUID.fromString(uuidString);
        return UUIDUtils.base64Uuid(uuid);
    }

    public static String uncompress(String compressedUuid) {
        if (compressedUuid.length() != 22) {
            throw new IllegalArgumentException("Invalid uuid!");
        }
        byte[] byUuid = Base64.getUrlDecoder().decode(compressedUuid + "==");
        long most = UUIDUtils.bytesToLong(byUuid, 0);
        long least = UUIDUtils.bytesToLong(byUuid, 8);
        UUID uuid = new UUID(most, least);
        return uuid.toString();
    }

    private static long bytesToLong(byte[] bytes, int offset) {
        long value = 0L;
        for (int i = 7; i > -1; --i) {
            value |= ((long)bytes[offset++] & 0xFFL) << 8 * i;
        }
        return value;
    }

    public static void main(String[] args) {
        for (int i = 0; i < 100; ++i) {
            System.err.println("--->" + UUIDUtils.base58Uuid());
        }
    }
}

