/*
 * Decompiled with CFR 0.152.
 */
package com.ruijc.util;

import com.ruijc.util.StringUtils;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Arrays;
import java.util.Comparator;

public class FileUtils {
    public static final long KB = 1024L;
    public static final long MB = 0x100000L;
    public static final long GB = 0x40000000L;

    public static String tmpFilename(String filename) {
        String tmpDir = System.getProperty("java.io.tmpdir");
        return tmpDir + "/" + filename;
    }

    public static File buildFile(String fileName, boolean isDirectory) {
        File target = new File(fileName);
        if (isDirectory) {
            target.mkdirs();
        } else if (!target.getParentFile().exists()) {
            target.getParentFile().mkdirs();
            target = new File(target.getAbsolutePath());
        }
        return target;
    }

    public static String getExt(String filename) {
        if (filename != null && filename.length() > 0) {
            int dot = filename.lastIndexOf(46);
            if (dot > -1 && dot < filename.length() - 1) {
                return filename.substring(dot + 1);
            }
            if (-1 == dot) {
                return "";
            }
        }
        return filename;
    }

    public static String getExt(File file) {
        return FileUtils.getExt(file.getName());
    }

    public static String getNameWithoutExt(String filename) {
        int dot;
        if (filename != null && filename.length() > 0 && (dot = filename.lastIndexOf(46)) > -1 && dot < filename.length()) {
            return filename.substring(0, dot);
        }
        return filename;
    }

    public static String getNameWithoutExt(File file) {
        return FileUtils.getNameWithoutExt(file.getName());
    }

    public static File rename(File file, String name) {
        File newFile;
        String dir = file.getParentFile().getAbsolutePath();
        String ext = FileUtils.getExt(name);
        if (StringUtils.isBlank(ext)) {
            name = name + "." + FileUtils.getExt(file.getName());
        }
        if (file.renameTo(newFile = new File(dir + "/" + name))) {
            return newFile;
        }
        return null;
    }

    public static File[] listFilesByName(File path) {
        File[] files = path.listFiles();
        FileUtils.sortFilesByName(files);
        return files;
    }

    public static File[] listFilesByName(File path, FilenameFilter filter) {
        File[] files = path.listFiles(filter);
        FileUtils.sortFilesByName(files);
        return files;
    }

    private static void sortFilesByName(File[] files) {
        Arrays.sort(files, new WindowsExplorerComparator());
    }

    public static void main(String[] args) {
        FileUtils.rename(new File("./test.txt"), "new.mp4");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class WindowsExplorerComparator
    implements Comparator<File> {
        private String str1;
        private String str2;
        private int pos1;
        private int pos2;
        private int len1;
        private int len2;

        @Override
        public int compare(File f1, File f2) {
            this.str1 = f1.getName();
            this.str2 = f2.getName();
            this.len1 = this.str1.length();
            this.len2 = this.str2.length();
            this.pos2 = 0;
            this.pos1 = 0;
            int result = 0;
            while (result == 0 && this.pos1 < this.len1 && this.pos2 < this.len2) {
                char ch1 = this.str1.charAt(this.pos1);
                char ch2 = this.str2.charAt(this.pos2);
                result = Character.isDigit(ch1) ? (Character.isDigit(ch2) ? this.compareNumbers() : -1) : (Character.isLetter(ch1) ? (Character.isLetter(ch2) ? this.compareOther(true) : 1) : (Character.isDigit(ch2) ? 1 : (Character.isLetter(ch2) ? -1 : this.compareOther(false))));
                ++this.pos1;
                ++this.pos2;
            }
            return result == 0 ? this.len1 - this.len2 : result;
        }

        private int compareNumbers() {
            int end2;
            int end1;
            for (end1 = this.pos1 + 1; end1 < this.len1 && Character.isDigit(this.str1.charAt(end1)); ++end1) {
            }
            int fullLen1 = end1 - this.pos1;
            while (this.pos1 < end1 && this.str1.charAt(this.pos1) == '0') {
                ++this.pos1;
            }
            for (end2 = this.pos2 + 1; end2 < this.len2 && Character.isDigit(this.str2.charAt(end2)); ++end2) {
            }
            int fullLen2 = end2 - this.pos2;
            while (this.pos2 < end2 && this.str2.charAt(this.pos2) == '0') {
                ++this.pos2;
            }
            int delta = end1 - this.pos1 - (end2 - this.pos2);
            if (delta != 0) {
                return delta;
            }
            while (this.pos1 < end1 && this.pos2 < end2) {
                if ((delta = this.str1.charAt(this.pos1++) - this.str2.charAt(this.pos2++)) == 0) continue;
                return delta;
            }
            --this.pos1;
            --this.pos2;
            return fullLen2 - fullLen1;
        }

        private int compareOther(boolean isLetters) {
            char ch2;
            char ch1 = this.str1.charAt(this.pos1);
            if (ch1 == (ch2 = this.str2.charAt(this.pos2))) {
                return 0;
            }
            if (isLetters && (ch1 = Character.toUpperCase(ch1)) != (ch2 = Character.toUpperCase(ch2))) {
                ch1 = Character.toLowerCase(ch1);
                ch2 = Character.toLowerCase(ch2);
            }
            return ch1 - ch2;
        }
    }
}

