/*
 * Decompiled with CFR 0.152.
 */
package com.ruijc.fastjson.filter;

import com.alibaba.fastjson.serializer.JSONSerializer;
import com.alibaba.fastjson.serializer.SimplePropertyPreFilter;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleSerializerFilter
extends SimplePropertyPreFilter {
    private Map<Class, HashSet<String>> includes;
    private Map<Class, HashSet<String>> excludes;

    public SimpleSerializerFilter(Map<Class, HashSet<String>> includes, Map<Class, HashSet<String>> excludes) {
        super(new String[0]);
        this.includes = includes;
        this.excludes = excludes;
    }

    public boolean apply(JSONSerializer serializer, Object source, String name) {
        Set includeProp;
        Class objClass;
        if (!this.isEmpty(this.includes)) {
            for (Map.Entry<Class, HashSet<String>> include : this.includes.entrySet()) {
                objClass = include.getKey();
                includeProp = include.getValue();
                if (!objClass.isAssignableFrom(source.getClass())) continue;
                return includeProp.contains(name);
            }
        }
        if (!this.isEmpty(this.excludes)) {
            for (Map.Entry<Class, HashSet<String>> exclude : this.excludes.entrySet()) {
                objClass = exclude.getKey();
                includeProp = exclude.getValue();
                if (!objClass.isAssignableFrom(source.getClass())) continue;
                return !includeProp.contains(name);
            }
        }
        return true;
    }

    public boolean isEmpty(Map map) {
        return map == null || map.size() < 1;
    }
}

