/*
 * Decompiled with CFR 0.152.
 */
package com.ruijc.fastjson.converter;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.support.spring.FastJsonHttpMessageConverter;
import com.ruijc.fastjson.bean.FastJsonFilterObject;
import com.ruijc.fastjson.filter.SimpleSerializerFilter;
import com.ruijc.util.StringUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageNotWritableException;

public class MyFastJsonHttpMessageConverter
extends FastJsonHttpMessageConverter {
    private static Charset UTF_8 = Charset.forName("UTF-8");

    public MyFastJsonHttpMessageConverter() {
        this.setSupportedMediaTypes(Arrays.asList(new MediaType("application", "json", UTF_8), new MediaType("application", "*+json", UTF_8), new MediaType("application", "jsonp", UTF_8), new MediaType("application", "*+jsonp", UTF_8)));
    }

    protected void writeInternal(Object obj, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        if (obj instanceof FastJsonFilterObject) {
            FastJsonFilterObject jsonFilterObject = (FastJsonFilterObject)obj;
            OutputStream out = outputMessage.getBody();
            SimpleSerializerFilter simpleSerializerFilter = new SimpleSerializerFilter(jsonFilterObject.getIncludes(), jsonFilterObject.getExcludes());
            String text = JSON.toJSONString((Object)jsonFilterObject.getData(), (SerializeFilter)simpleSerializerFilter, (SerializerFeature[])this.getFastJsonConfig().getSerializerFeatures());
            String callback = jsonFilterObject.getCallback();
            if (!StringUtils.isBlank((String)callback)) {
                text = callback + "(" + text + ")";
            }
            byte[] bytes = text.getBytes(this.getFastJsonConfig().getCharset());
            out.write(bytes);
        } else {
            OutputStream out = outputMessage.getBody();
            String text = JSON.toJSONString((Object)obj, (SerializerFeature[])this.getFastJsonConfig().getSerializerFeatures());
            byte[] bytes = text.getBytes(this.getFastJsonConfig().getCharset());
            out.write(bytes);
        }
    }
}

