/*
 * Decompiled with CFR 0.152.
 */
package com.ruijc.fastjson.converter;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.support.spring.FastJsonHttpMessageConverter;
import com.ruijc.fastjson.bean.JsonFilterObject;
import com.ruijc.fastjson.filter.SimpleSerializerFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageNotWritableException;

public class FastjsonHttpMessageConverter
extends FastJsonHttpMessageConverter {
    public FastjsonHttpMessageConverter() {
        this.setSupportedMediaTypes(Arrays.asList(new MediaType("application", "json", Charset.forName("UTF-8")), new MediaType("application", "*+json", Charset.forName("UTF-8")), new MediaType("application", "jsonp", Charset.forName("UTF-8")), new MediaType("application", "*+jsonp", Charset.forName("UTF-8"))));
    }

    protected void writeInternal(Object obj, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        if (obj instanceof JsonFilterObject) {
            JsonFilterObject jsonFilterObject = (JsonFilterObject)obj;
            OutputStream out = outputMessage.getBody();
            SimpleSerializerFilter simpleSerializerFilter = new SimpleSerializerFilter(jsonFilterObject.getIncludes(), jsonFilterObject.getExcludes());
            String text = JSON.toJSONString((Object)jsonFilterObject.getData(), (SerializeFilter)simpleSerializerFilter, (SerializerFeature[])this.getFastJsonConfig().getSerializerFeatures());
            String callback = jsonFilterObject.getCallback();
            if (!"".equals(callback)) {
                text = callback + "(" + text + ")";
            }
            byte[] bytes = text.getBytes(this.getFastJsonConfig().getCharset());
            out.write(bytes);
        } else {
            OutputStream out = outputMessage.getBody();
            String text = JSON.toJSONString((Object)obj, (SerializerFeature[])this.getFastJsonConfig().getSerializerFeatures());
            byte[] bytes = text.getBytes(this.getFastJsonConfig().getCharset());
            out.write(bytes);
        }
    }
}

