package com.ruijc.fastjson.converter;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.support.spring.FastJsonHttpMessageConverter;
import com.ruijc.fastjson.bean.JsonFilterObject;
import com.ruijc.fastjson.filter.SimpleSerializerFilter;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageNotWritableException;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Arrays;

/**
 * Created by Liuyis on 2016/2/11.
 */
public class FastjsonHttpMessageConverter extends FastJsonHttpMessageConverter {

    public FastjsonHttpMessageConverter() {
        setSupportedMediaTypes(Arrays.asList(
                new MediaType("application", "json", Charset.forName("UTF-8")),
                new MediaType("application", "*+json", Charset.forName("UTF-8")),
                new MediaType("application", "jsonp", Charset.forName("UTF-8")),
                new MediaType("application", "*+jsonp", Charset.forName("UTF-8")))
        );
    }

    @Override
    protected void writeInternal(Object obj, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        if (obj instanceof JsonFilterObject) {
            JsonFilterObject jsonFilterObject = (JsonFilterObject) obj;
            OutputStream out = outputMessage.getBody();
            SimpleSerializerFilter simpleSerializerFilter = new SimpleSerializerFilter(jsonFilterObject.getIncludes(), jsonFilterObject.getExcludes());
            String text = JSON.toJSONString(jsonFilterObject.getData(), simpleSerializerFilter, getFastJsonConfig().getSerializerFeatures());
            String callback = jsonFilterObject.getCallback();
            if (!"".equals(callback)) {
                text = callback + "(" + text + ")";
            }
            byte[] bytes = text.getBytes(getFastJsonConfig().getCharset());
            out.write(bytes);
        } else {
            OutputStream out = outputMessage.getBody();
            String text = JSON.toJSONString(obj, getFastJsonConfig().getSerializerFeatures());
            byte[] bytes = text.getBytes(getFastJsonConfig().getCharset());
            out.write(bytes);
        }
    }
}
