package com.ruijc.fastjson;

import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.serializer.ValueFilter;
import com.alibaba.fastjson.support.config.FastJsonConfig;
import com.alibaba.fastjson.support.spring.FastJsonHttpMessageConverter;

/**
 * Fastjson自动化配置
 * @author Storezhang
 */
@Configuration
@ConditionalOnClass({ JSON.class })
public class FastJsonHttpMessageConvertersConfiguration {

    @Configuration
    @ConditionalOnClass({ FastJsonHttpMessageConverter.class })
    @ConditionalOnProperty(name = { "spring.http.converters.preferred-json-mapper" }, havingValue = "fastjson", matchIfMissing = true)
    protected static class FastJson2HttpMessageConverterConfiguration {
        @Bean
        @ConditionalOnMissingBean({ FastJsonHttpMessageConverter.class })
        public FastjsonHttpMessageConverter fastJsonHttpMessageConverter() {
            FastjsonHttpMessageConverter converter = new FastjsonHttpMessageConverter();

            FastJsonConfig config = new FastJsonConfig();
            config.setSerializerFeatures(
                    SerializerFeature.PrettyFormat,
                    SerializerFeature.WriteMapNullValue,
                    SerializerFeature.WriteNullListAsEmpty,
                    SerializerFeature.WriteNullStringAsEmpty
            );

            config.setSerializeFilters(new ValueFilter() {
                public Object process(Object o, String s, Object o1) {
                    if (null == o1) {
                        o1 = "";
                    }

                    return o1;
                }
            });
            converter.setFastJsonConfig(config);

            return converter;
        }
    }
}
