/*
 * Decompiled with CFR 0.152.
 */
package com.rometools.modules.georss;

import com.rometools.modules.georss.GMLParser;
import com.rometools.modules.georss.GeoRSSModule;
import com.rometools.modules.georss.SimpleModuleImpl;
import com.rometools.modules.georss.geometries.Envelope;
import com.rometools.modules.georss.geometries.LineString;
import com.rometools.modules.georss.geometries.LinearRing;
import com.rometools.modules.georss.geometries.Point;
import com.rometools.modules.georss.geometries.Polygon;
import com.rometools.modules.georss.geometries.Position;
import com.rometools.modules.georss.geometries.PositionList;
import com.rometools.rome.feed.module.Module;
import com.rometools.rome.io.ModuleParser;
import com.rometools.utils.Doubles;
import com.rometools.utils.Strings;
import java.util.Locale;
import org.jdom2.Element;

public class SimpleParser
implements ModuleParser {
    public String getNamespaceUri() {
        return "http://www.georss.org/georss";
    }

    private static PositionList parsePosList(Element element) {
        PositionList posList = null;
        String coordinates = Strings.trimToNull((String)element.getText());
        if (coordinates != null) {
            posList = new PositionList();
            String[] coord = coordinates.split("\\s+");
            for (int i = 0; i < coord.length; i += 2) {
                double longitude;
                double latitude;
                try {
                    latitude = Double.parseDouble(coord[i]);
                    longitude = Double.parseDouble(coord[i + 1]);
                }
                catch (NumberFormatException e) {
                    return null;
                }
                posList.add(latitude, longitude);
            }
        }
        return posList;
    }

    public Module parse(Element element, Locale locale) {
        return SimpleParser.parseSimple(element);
    }

    static Module parseSimple(Element element) {
        Element pointElement = element.getChild("point", GeoRSSModule.SIMPLE_NS);
        Element lineElement = element.getChild("line", GeoRSSModule.SIMPLE_NS);
        Element polygonElement = element.getChild("polygon", GeoRSSModule.SIMPLE_NS);
        Element boxElement = element.getChild("box", GeoRSSModule.SIMPLE_NS);
        Element whereElement = element.getChild("where", GeoRSSModule.SIMPLE_NS);
        GeoRSSModule geoRSSModule = null;
        if (pointElement != null) {
            String[] coord;
            String coordinates = Strings.trimToNull((String)pointElement.getText());
            if (coordinates != null && (coord = coordinates.split("\\s+")).length == 2) {
                Double latitude = Doubles.parse((String)coord[0]);
                Double longitude = Doubles.parse((String)coord[1]);
                if (latitude != null && longitude != null) {
                    Position pos = new Position(latitude, longitude);
                    Point point = new Point(pos);
                    geoRSSModule = new SimpleModuleImpl();
                    geoRSSModule.setGeometry(point);
                }
            }
        } else if (lineElement != null) {
            PositionList posList = SimpleParser.parsePosList(lineElement);
            if (posList != null) {
                LineString lineString = new LineString(posList);
                geoRSSModule = new SimpleModuleImpl();
                geoRSSModule.setGeometry(lineString);
            }
        } else if (polygonElement != null) {
            PositionList posList = SimpleParser.parsePosList(polygonElement);
            if (posList != null) {
                LinearRing linearRing = new LinearRing(posList);
                Polygon poly = new Polygon();
                poly.setExterior(linearRing);
                geoRSSModule = new SimpleModuleImpl();
                geoRSSModule.setGeometry(poly);
            }
        } else if (boxElement != null) {
            String coordinates = Strings.trimToNull((String)boxElement.getText());
            if (coordinates != null) {
                double right;
                double top;
                double left;
                double bottom;
                String[] coord = coordinates.split("\\s+");
                try {
                    bottom = Double.parseDouble(coord[0]);
                    left = Double.parseDouble(coord[1]);
                    top = Double.parseDouble(coord[2]);
                    right = Double.parseDouble(coord[3]);
                }
                catch (NumberFormatException e) {
                    return null;
                }
                Envelope envelope = new Envelope(bottom, left, top, right);
                geoRSSModule = new SimpleModuleImpl();
                geoRSSModule.setGeometry(envelope);
            }
        } else if (whereElement != null) {
            geoRSSModule = (GeoRSSModule)GMLParser.parseGML(whereElement);
        }
        return geoRSSModule;
    }
}

