/*
 * Decompiled with CFR 0.152.
 */
package com.rometools.modules.georss;

import com.rometools.modules.georss.GeoRSSModule;
import com.rometools.modules.georss.W3CGeoModuleImpl;
import com.rometools.modules.georss.geometries.Point;
import com.rometools.modules.georss.geometries.Position;
import com.rometools.rome.feed.module.Module;
import com.rometools.rome.io.ModuleParser;
import com.rometools.utils.Strings;
import java.util.Locale;
import org.jdom2.Element;

public class W3CGeoParser
implements ModuleParser {
    public String getNamespaceUri() {
        return "http://www.w3.org/2003/01/geo/wgs84_pos#";
    }

    static Module parseW3C(Element element) {
        W3CGeoModuleImpl geoRSSModule = null;
        Element pointElement = element.getChild("Point", GeoRSSModule.W3CGEO_NS);
        if (pointElement == null) {
            pointElement = element;
        }
        Element lat = pointElement.getChild("lat", GeoRSSModule.W3CGEO_NS);
        Element lng = pointElement.getChild("long", GeoRSSModule.W3CGEO_NS);
        if (lng == null) {
            lng = pointElement.getChild("lon", GeoRSSModule.W3CGEO_NS);
        }
        if (lat != null && lng != null) {
            geoRSSModule = new W3CGeoModuleImpl();
            String latTxt = Strings.trimToNull((String)lat.getText());
            String lngTxt = Strings.trimToNull((String)lng.getText());
            if (latTxt != null && lngTxt != null) {
                double latitude = Double.parseDouble(lat.getText());
                double longitude = Double.parseDouble(lng.getText());
                Position position = new Position(latitude, longitude);
                Point point = new Point(position);
                geoRSSModule.setGeometry(point);
            }
        }
        return geoRSSModule;
    }

    public Module parse(Element element, Locale locale) {
        return W3CGeoParser.parseW3C(element);
    }
}

