/*
 * Decompiled with CFR 0.152.
 */
package com.rometools.modules.itunes;

import com.rometools.modules.itunes.AbstractITunesObject;
import com.rometools.modules.itunes.EntryInformation;
import com.rometools.modules.itunes.types.Duration;
import com.rometools.rome.feed.CopyFrom;

public class EntryInformationImpl
extends AbstractITunesObject
implements EntryInformation {
    private static final long serialVersionUID = 1L;
    private Duration duration;

    @Override
    public Duration getDuration() {
        return this.duration;
    }

    @Override
    public void setDuration(Duration duration) {
        this.duration = duration;
    }

    public void copyFrom(CopyFrom obj) {
        EntryInformationImpl info = (EntryInformationImpl)obj;
        this.setAuthor(info.getAuthor());
        this.setBlock(info.getBlock());
        if (info.getDuration() != null) {
            this.setDuration(new Duration(info.getDuration().getMilliseconds()));
        }
        this.setExplicit(info.getExplicit());
        if (info.getKeywords() != null) {
            this.setKeywords((String[])info.getKeywords().clone());
        }
        this.setSubtitle(info.getSubtitle());
        this.setSummary(info.getSummary());
    }

    @Override
    public Object clone() {
        EntryInformationImpl info = new EntryInformationImpl();
        info.copyFrom((CopyFrom)this);
        return info;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("[");
        sb.append(" Duration: ");
        sb.append(this.getDuration());
        sb.append("]");
        sb.append(super.toString());
        return sb.toString();
    }
}

