/*
 * Decompiled with CFR 0.152.
 */
package com.rometools.modules.mediarss.types;

import com.rometools.rome.feed.impl.EqualsBean;
import com.rometools.rome.feed.impl.ToStringBean;
import java.io.Serializable;

public class Restriction
implements Serializable {
    private static final long serialVersionUID = 7944281267467298628L;
    private final Relationship relationship;
    private final String value;
    private final Type type;

    public Restriction(Relationship relationship, Type type, String value) {
        if (value == null || relationship == null) {
            throw new NullPointerException("Value and Relationship cannot be null.");
        }
        if (type == null && !value.equals("all") && !value.equals("none")) {
            throw new NullPointerException("Type is required if the value is other than 'all' or 'none'.");
        }
        this.relationship = relationship;
        this.type = type;
        this.value = value;
    }

    public Relationship getRelationship() {
        return this.relationship;
    }

    public Type getType() {
        return this.type;
    }

    public String getValue() {
        return this.value;
    }

    public boolean equals(Object obj) {
        return EqualsBean.beanEquals(this.getClass(), (Object)this, (Object)obj);
    }

    public int hashCode() {
        return EqualsBean.beanHashCode((Object)this);
    }

    public String toString() {
        return ToStringBean.toString(this.getClass(), (Object)this);
    }

    public static final class Type {
        public static final Type COUNTRY = new Type("country");
        public static final Type SHARING = new Type("sharing");
        public static final Type URI = new Type("uri");
        private final String value;

        private Type(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static final class Relationship {
        public static final Relationship ALLOW = new Relationship("allow");
        public static final Relationship DENY = new Relationship("deny");
        private final String value;

        private Relationship(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

