/*
 * Decompiled with CFR 0.152.
 */
package com.rometools.modules.atom.io;

import com.rometools.modules.atom.modules.AtomLinkModuleImpl;
import com.rometools.rome.feed.atom.Link;
import com.rometools.rome.feed.module.Module;
import com.rometools.rome.io.ModuleParser;
import com.rometools.rome.io.impl.NumberParser;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.jdom2.Attribute;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class AtomModuleParser
implements ModuleParser {
    private static final Namespace NS = Namespace.getNamespace((String)"http://www.w3.org/2005/Atom");

    public String getNamespaceUri() {
        return null;
    }

    public Module parse(Element element, Locale locale) {
        AtomLinkModuleImpl mod = new AtomLinkModuleImpl();
        if (element.getName().equals("channel") || element.getName().equals("item")) {
            List links = element.getChildren("link", NS);
            LinkedList<Link> result = new LinkedList<Link>();
            for (Element link : links) {
                Link l = this.parseLink(link);
                result.add(l);
            }
            mod.setLinks(result);
            return mod;
        }
        return null;
    }

    private Link parseLink(Element eLink) {
        Long val;
        String length;
        String hrefLang;
        String title;
        String href;
        String type;
        Link link = new Link();
        String rel = this.getAttributeValue(eLink, "rel");
        if (rel != null) {
            link.setRel(rel);
        }
        if ((type = this.getAttributeValue(eLink, "type")) != null) {
            link.setType(type);
        }
        if ((href = this.getAttributeValue(eLink, "href")) != null) {
            link.setHref(href);
        }
        if ((title = this.getAttributeValue(eLink, "title")) != null) {
            link.setTitle(title);
        }
        if ((hrefLang = this.getAttributeValue(eLink, "hreflang")) != null) {
            link.setHreflang(hrefLang);
        }
        if ((length = this.getAttributeValue(eLink, "length")) != null && (val = NumberParser.parseLong((String)length)) != null) {
            link.setLength(val.longValue());
        }
        return link;
    }

    protected String getAttributeValue(Element e, String attributeName) {
        Attribute attr = e.getAttribute(attributeName);
        if (attr == null) {
            attr = e.getAttribute(attributeName, NS);
        }
        if (attr != null) {
            return attr.getValue();
        }
        return null;
    }
}

