/*
 * Decompiled with CFR 0.152.
 */
package com.rometools.modules.itunes;

import com.rometools.modules.itunes.AbstractITunesObject;
import com.rometools.modules.itunes.EntryInformation;
import com.rometools.modules.itunes.types.Duration;
import com.rometools.rome.feed.CopyFrom;
import java.net.MalformedURLException;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntryInformationImpl
extends AbstractITunesObject
implements EntryInformation {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(EntryInformationImpl.class);
    private Duration duration;
    private boolean closedCaptioned;
    private Integer order;
    private String episodeType;
    private Integer season;
    private Integer episode;

    @Override
    public Duration getDuration() {
        return this.duration;
    }

    @Override
    public void setDuration(Duration duration) {
        this.duration = duration;
    }

    @Override
    public boolean getClosedCaptioned() {
        return this.closedCaptioned;
    }

    @Override
    public void setClosedCaptioned(boolean closedCaptioned) {
        this.closedCaptioned = closedCaptioned;
    }

    @Override
    public Integer getOrder() {
        return this.order;
    }

    @Override
    public void setOrder(Integer order) {
        this.order = order;
    }

    @Override
    public String getEpisodeType() {
        return this.episodeType;
    }

    @Override
    public void setEpisodeType(String episodeType) {
        this.episodeType = episodeType;
    }

    @Override
    public Integer getSeason() {
        return this.season;
    }

    @Override
    public void setSeason(Integer season) {
        this.season = season;
    }

    @Override
    public Integer getEpisode() {
        return this.episode;
    }

    @Override
    public void setEpisode(Integer episode) {
        this.episode = episode;
    }

    public void copyFrom(CopyFrom obj) {
        EntryInformationImpl info = (EntryInformationImpl)obj;
        this.setAuthor(info.getAuthor());
        this.setBlock(info.getBlock());
        if (info.getDuration() != null) {
            this.setDuration(new Duration(info.getDuration().getMilliseconds()));
        }
        this.setExplicitNullable(info.getExplicitNullable());
        try {
            if (info.getImage() != null) {
                this.setImage(new URL(info.getImage().toExternalForm()));
            }
        }
        catch (MalformedURLException e) {
            LOG.debug("Error copying URL:" + info.getImage(), (Throwable)e);
        }
        if (info.getKeywords() != null) {
            this.setKeywords((String[])info.getKeywords().clone());
        }
        this.setSubtitle(info.getSubtitle());
        this.setSummary(info.getSummary());
        this.setClosedCaptioned(info.getClosedCaptioned());
        this.setOrder(info.getOrder());
        this.setEpisodeType(info.getEpisodeType());
        this.setSeason(info.getSeason());
        this.setEpisode(info.getEpisode());
    }

    @Override
    public Object clone() {
        EntryInformationImpl info = new EntryInformationImpl();
        info.copyFrom((CopyFrom)this);
        return info;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("[");
        sb.append(" duration: ");
        sb.append(this.getDuration());
        sb.append(" closedCaptioned: ");
        sb.append(this.getClosedCaptioned());
        sb.append(" order: ");
        sb.append(this.getOrder());
        sb.append(" season: ");
        sb.append(this.getSeason());
        sb.append(" episode: ");
        sb.append(this.getEpisode());
        sb.append(" episodeType: ");
        sb.append(this.getEpisodeType());
        sb.append("]");
        sb.append(super.toString());
        return sb.toString();
    }
}

