/*
 * Decompiled with CFR 0.152.
 */
package com.rollbar.notifier.truncation;

import com.rollbar.api.payload.Payload;
import com.rollbar.api.payload.data.Data;
import com.rollbar.api.payload.data.body.Body;
import com.rollbar.api.payload.data.body.BodyContent;
import com.rollbar.api.payload.data.body.Frame;
import com.rollbar.api.payload.data.body.Trace;
import com.rollbar.api.payload.data.body.TraceChain;
import com.rollbar.notifier.truncation.TruncationStrategy;
import java.util.ArrayList;
import java.util.List;

class FramesStrategy
implements TruncationStrategy {
    private final int headFrameCount;
    private final int tailFrameCount;

    public FramesStrategy() {
        this(10, 10);
    }

    public FramesStrategy(int headFrameCount, int tailFrameCount) {
        this.headFrameCount = headFrameCount;
        this.tailFrameCount = tailFrameCount;
    }

    @Override
    public TruncationStrategy.TruncationResult<Payload> truncate(Payload payload) {
        if (payload == null || payload.getData() == null || payload.getData().getBody() == null) {
            return TruncationStrategy.TruncationResult.none();
        }
        Body body = payload.getData().getBody();
        BodyContent content = body.getContents();
        if (content instanceof Trace) {
            return this.mapResult(payload, this.truncateTrace((Trace)content));
        }
        if (content instanceof TraceChain) {
            return this.mapResult(payload, this.truncateTraceChain((TraceChain)content));
        }
        return TruncationStrategy.TruncationResult.none();
    }

    private TruncationStrategy.TruncationResult<TraceChain> truncateTraceChain(TraceChain chain) {
        boolean truncated = false;
        ArrayList<Object> updated = new ArrayList<Object>();
        for (Trace trace : chain.getTraces()) {
            TruncationStrategy.TruncationResult<Trace> result = this.truncateTrace(trace);
            if (result.wasTruncated) {
                updated.add(result.value);
            } else {
                updated.add(trace);
            }
            truncated |= result.wasTruncated;
        }
        if (truncated) {
            return TruncationStrategy.TruncationResult.truncated(new TraceChain.Builder(chain).traces(updated).build());
        }
        return TruncationStrategy.TruncationResult.none();
    }

    private TruncationStrategy.TruncationResult<Trace> truncateTrace(Trace trace) {
        List frames = trace.getFrames();
        if (frames.size() <= this.totalFramesToKeep()) {
            return TruncationStrategy.TruncationResult.none();
        }
        List<Frame> updatedFrames = this.truncateFrames(frames);
        return TruncationStrategy.TruncationResult.truncated(new Trace.Builder(trace).frames(updatedFrames).build());
    }

    int totalFramesToKeep() {
        return this.headFrameCount + this.tailFrameCount;
    }

    List<Frame> truncateFrames(List<Frame> frames) {
        ArrayList<Frame> updatedFrames = new ArrayList<Frame>();
        for (int j = 0; j < this.headFrameCount; ++j) {
            updatedFrames.add(frames.get(j));
        }
        int size = frames.size();
        for (int j = size - this.tailFrameCount; j < size; ++j) {
            updatedFrames.add(frames.get(j));
        }
        return updatedFrames;
    }

    private <T extends BodyContent> TruncationStrategy.TruncationResult<Payload> mapResult(Payload payload, TruncationStrategy.TruncationResult<T> result) {
        if (!result.wasTruncated) {
            return TruncationStrategy.TruncationResult.none();
        }
        Payload newPayload = new Payload.Builder(payload).data(new Data.Builder(payload.getData()).body(new Body.Builder(payload.getData().getBody()).bodyContent((BodyContent)result.value).build()).build()).build();
        return TruncationStrategy.TruncationResult.truncated(newPayload);
    }
}

