/*
 * Decompiled with CFR 0.152.
 */
package com.rollbar.android;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.util.Log;
import com.rollbar.android.notifier.sender.ConnectionAwareSenderFailureStrategy;
import com.rollbar.android.provider.ClientProvider;
import com.rollbar.android.provider.NotifierProvider;
import com.rollbar.android.provider.PersonProvider;
import com.rollbar.api.payload.data.Level;
import com.rollbar.notifier.config.Config;
import com.rollbar.notifier.config.ConfigBuilder;
import com.rollbar.notifier.config.ConfigProvider;
import com.rollbar.notifier.provider.Provider;
import com.rollbar.notifier.sender.BufferedSender;
import com.rollbar.notifier.sender.Sender;
import com.rollbar.notifier.sender.SenderFailureStrategy;
import com.rollbar.notifier.sender.SyncSender;
import com.rollbar.notifier.sender.queue.DiskQueue;
import com.rollbar.notifier.uncaughtexception.RollbarUncaughtExceptionHandler;
import com.rollbar.notifier.util.ObjectsUtils;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.TimeUnit;

public class Rollbar
implements Closeable {
    private static final String ITEM_DIR_NAME = "rollbar-items";
    private static final String ANDROID = "android";
    private static final String DEFAULT_ENVIRONMENT = "production";
    private static final int DEFAULT_ITEM_SCHEDULE_STARTUP_DELAY = 1;
    private static final int DEFAULT_ITEM_SCHEDULE_DELAY = 15;
    private static final boolean DEFAULT_REGISTER_EXCEPTION_HANDLER = true;
    private static final boolean DEFAULT_INCLUDE_LOGCAT = false;
    private static final ConfigProvider DEFAULT_CONFIG_PROVIDER = null;
    private static final String DEFAULT_CAPTURE_IP = "full";
    private static final int DEFAULT_MAX_LOGCAT_SIZE = -1;
    private static final boolean DEFAULT_SUSPEND_WHEN_NETWORK_IS_UNAVAILABLE = false;
    public static final String TAG = "Rollbar";
    private static final String MANIFEST_ACCESS_TOKEN = "com.rollbar.android.ACCESS_TOKEN";
    private final ConnectionAwareSenderFailureStrategy senderFailureStrategy;
    private com.rollbar.notifier.Rollbar rollbar;
    private static Rollbar notifier;
    private final int versionCode;
    private final String versionName;

    public static Rollbar init(Context context) {
        return Rollbar.init(context, null, null);
    }

    public static Rollbar init(Context context, String accessToken, String environment) {
        return Rollbar.init(context, accessToken, environment, true);
    }

    public static Rollbar init(Context context, String accessToken, boolean suspendWhenNetworkIsUnavailable) {
        return Rollbar.init(context, accessToken, DEFAULT_ENVIRONMENT, true, false, DEFAULT_CONFIG_PROVIDER, suspendWhenNetworkIsUnavailable);
    }

    public static Rollbar init(Context context, String accessToken, String environment, boolean registerExceptionHandler) {
        return Rollbar.init(context, accessToken, environment, registerExceptionHandler, false);
    }

    public static Rollbar init(Context context, String accessToken, String environment, boolean registerExceptionHandler, boolean includeLogcat) {
        return Rollbar.init(context, accessToken, environment, registerExceptionHandler, includeLogcat, DEFAULT_CONFIG_PROVIDER);
    }

    public static Rollbar init(Context context, String accessToken, String environment, boolean registerExceptionHandler, boolean includeLogcat, ConfigProvider provider) {
        return Rollbar.init(context, accessToken, environment, registerExceptionHandler, includeLogcat, provider, false);
    }

    public static Rollbar init(Context context, String accessToken, String environment, boolean registerExceptionHandler, boolean includeLogcat, ConfigProvider provider, boolean suspendWhenNetworkIsUnavailable) {
        if (Rollbar.isInit()) {
            Log.w((String)TAG, (String)"Rollbar.init() called when it was already initialized.");
            notifier.updateContext(context);
        } else {
            notifier = new Rollbar(context, accessToken, environment, registerExceptionHandler, includeLogcat, provider, DEFAULT_CAPTURE_IP, -1, suspendWhenNetworkIsUnavailable);
        }
        return notifier;
    }

    private void updateContext(Context context) {
        if (this.senderFailureStrategy != null) {
            this.senderFailureStrategy.updateContext(context);
        }
    }

    public static Rollbar init(Context context, ConfigProvider provider) {
        if (Rollbar.isInit()) {
            Log.w((String)TAG, (String)"Rollbar.init() called when it was already initialized.");
        } else {
            notifier = new Rollbar(context, null, null, true, false, provider);
        }
        return notifier;
    }

    @Override
    public void close() throws IOException {
        if (this.rollbar != null) {
            try {
                this.rollbar.close(false);
            }
            catch (Exception e) {
                throw new IOException(e);
            }
            this.rollbar = null;
        }
    }

    public static boolean isInit() {
        return notifier != null;
    }

    public static Rollbar instance() {
        if (Rollbar.isInit()) {
            return notifier;
        }
        Log.w((String)TAG, (String)"Attempt to access Rollbar.instance() before initialization.");
        return null;
    }

    public Rollbar(Context context) {
        this(context, null, null, true);
    }

    public Rollbar(Context context, String accessToken, String environment, boolean registerExceptionHandler) {
        this(context, accessToken, environment, registerExceptionHandler, false, null);
    }

    public Rollbar(Context context, String accessToken, String environment, boolean registerExceptionHandler, boolean includeLogcat) {
        this(context, accessToken, environment, registerExceptionHandler, includeLogcat, null);
    }

    public Rollbar(Context context, String accessToken, String environment, boolean registerExceptionHandler, boolean includeLogcat, ConfigProvider configProvider) {
        this(context, accessToken, environment, registerExceptionHandler, includeLogcat, configProvider, DEFAULT_CAPTURE_IP);
    }

    public Rollbar(Context context, String accessToken, String environment, boolean registerExceptionHandler, boolean includeLogcat, ConfigProvider configProvider, String captureIp) {
        this(context, accessToken, environment, registerExceptionHandler, includeLogcat, configProvider, captureIp, -1);
    }

    public Rollbar(Context context, String accessToken, String environment, boolean registerExceptionHandler, boolean includeLogcat, ConfigProvider configProvider, String captureIp, int maxLogcatSize) {
        this(context, accessToken, environment, registerExceptionHandler, includeLogcat, configProvider, captureIp, maxLogcatSize, false);
    }

    public Rollbar(Context context, String accessToken, String environment, boolean registerExceptionHandler, boolean includeLogcat, ConfigProvider configProvider, String captureIp, int maxLogcatSize, boolean suspendWhenNetworkIsUnavailable) {
        if (accessToken == null) {
            try {
                accessToken = this.loadAccessTokenFromManifest(context);
            }
            catch (PackageManager.NameNotFoundException e) {
                Log.e((String)TAG, (String)"Error getting access token from manifest.");
            }
        }
        PackageInfo info = null;
        try {
            String packageName = context.getPackageName();
            info = context.getPackageManager().getPackageInfo(packageName, 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.e((String)TAG, (String)"Error getting package info.");
        }
        this.versionCode = info != null ? info.versionCode : 0;
        this.versionName = info != null ? info.versionName : "unknown";
        ClientProvider clientProvider = new ClientProvider.Builder().versionCode(this.versionCode).versionName(this.versionName).includeLogcat(includeLogcat).captureIp(captureIp).maxLogcatSize(maxLogcatSize).build();
        File folder = new File(context.getCacheDir(), ITEM_DIR_NAME);
        DiskQueue queue = new DiskQueue.Builder().queueFolder(folder).build();
        SyncSender innerSender = new SyncSender.Builder().accessToken(accessToken).build();
        BufferedSender.Builder senderBuilder = new BufferedSender.Builder().queue((Queue)queue).sender((Sender)innerSender).initialFlushDelay(TimeUnit.SECONDS.toMillis(1L)).flushFreq(TimeUnit.SECONDS.toMillis(15L));
        if (suspendWhenNetworkIsUnavailable) {
            this.senderFailureStrategy = new ConnectionAwareSenderFailureStrategy(context);
            senderBuilder.senderFailureStrategy((SenderFailureStrategy)this.senderFailureStrategy);
        } else {
            this.senderFailureStrategy = null;
        }
        BufferedSender sender = senderBuilder.build();
        ConfigBuilder defaultConfig = ConfigBuilder.withAccessToken((String)accessToken).client((Provider)clientProvider).platform(ANDROID).framework(ANDROID).notifier((Provider)new NotifierProvider(context)).environment(environment == null ? DEFAULT_ENVIRONMENT : environment).sender((Sender)sender).handleUncaughtErrors(false);
        Config config = configProvider != null ? configProvider.provide(defaultConfig) : defaultConfig.build();
        if (config.sender() != sender) {
            ObjectsUtils.close((Closeable)sender);
        }
        this.rollbar = new com.rollbar.notifier.Rollbar(config);
        if (registerExceptionHandler) {
            this.handleUncaughtErrors();
        }
    }

    public Config config() {
        if (this.rollbar != null) {
            return this.rollbar.config();
        }
        return null;
    }

    public void setPersonData(final String id, final String username, final String email) {
        this.rollbar.configure(new ConfigProvider(){

            public Config provide(ConfigBuilder builder) {
                return builder.person((Provider)new PersonProvider(id, username, email)).build();
            }
        });
    }

    public void clearPersonData() {
        this.rollbar.configure(new ConfigProvider(){

            public Config provide(ConfigBuilder builder) {
                return builder.person(null).build();
            }
        });
    }

    public void setIncludeLogcat(final boolean includeLogcat) {
        final int versionCode = this.versionCode;
        final String versionName = this.versionName;
        this.rollbar.configure(new ConfigProvider(){

            public Config provide(ConfigBuilder builder) {
                ClientProvider clientProvider = new ClientProvider.Builder().versionCode(versionCode).versionName(versionName).includeLogcat(includeLogcat).build();
                return builder.client((Provider)clientProvider).build();
            }
        });
    }

    public void handleUncaughtErrors() {
        Thread.UncaughtExceptionHandler uncaughtExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
        Thread.currentThread();
        Thread.setDefaultUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new RollbarUncaughtExceptionHandler(this.rollbar, uncaughtExceptionHandler));
    }

    public void configure(ConfigProvider configProvider) {
        this.rollbar.configure(configProvider);
    }

    public void configure(Config config) {
        this.rollbar.configure(config);
    }

    public void critical(Throwable error) {
        this.critical(error, null, null);
    }

    public void critical(Throwable error, String description) {
        this.critical(error, null, description);
    }

    public void critical(Throwable error, Map<String, Object> custom) {
        this.critical(error, custom, null);
    }

    public void critical(String message) {
        this.critical(null, null, message);
    }

    public void critical(String message, Map<String, Object> custom) {
        this.critical(null, custom, message);
    }

    public void critical(Throwable error, Map<String, Object> custom, String description) {
        this.log(error, custom, description, Level.CRITICAL);
    }

    public void error(Throwable error) {
        this.error(error, null, null);
    }

    public void error(Throwable error, String description) {
        this.error(error, null, description);
    }

    public void error(Throwable error, Map<String, Object> custom) {
        this.error(error, custom, null);
    }

    public void error(String message) {
        this.error(null, null, message);
    }

    public void error(String message, Map<String, Object> custom) {
        this.error(null, custom, message);
    }

    public void error(Throwable error, Map<String, Object> custom, String description) {
        this.log(error, custom, description, Level.ERROR);
    }

    public void warning(Throwable error) {
        this.warning(error, null, null);
    }

    public void warning(Throwable error, String description) {
        this.warning(error, null, description);
    }

    public void warning(Throwable error, Map<String, Object> custom) {
        this.warning(error, custom, null);
    }

    public void warning(String message) {
        this.warning(null, null, message);
    }

    public void warning(String message, Map<String, Object> custom) {
        this.warning(null, custom, message);
    }

    public void warning(Throwable error, Map<String, Object> custom, String description) {
        this.log(error, custom, description, Level.WARNING);
    }

    public void info(Throwable error) {
        this.info(error, null, null);
    }

    public void info(Throwable error, String description) {
        this.info(error, null, description);
    }

    public void info(Throwable error, Map<String, Object> custom) {
        this.info(error, custom, null);
    }

    public void info(String message) {
        this.info(null, null, message);
    }

    public void info(String message, Map<String, Object> custom) {
        this.info(null, custom, message);
    }

    public void info(Throwable error, Map<String, Object> custom, String description) {
        this.log(error, custom, description, Level.INFO);
    }

    public void debug(Throwable error) {
        this.debug(error, null, null);
    }

    public void debug(Throwable error, String description) {
        this.debug(error, null, description);
    }

    public void debug(Throwable error, Map<String, Object> custom) {
        this.debug(error, custom, null);
    }

    public void debug(String message) {
        this.debug(null, null, message);
    }

    public void debug(String message, Map<String, Object> custom) {
        this.debug(null, custom, message);
    }

    public void debug(Throwable error, Map<String, Object> custom, String description) {
        this.log(error, custom, description, Level.DEBUG);
    }

    public void log(Throwable error) {
        this.log(error, null, null, null);
    }

    public void log(Throwable error, String description) {
        this.log(error, null, description, null);
    }

    public void log(Throwable error, Map<String, Object> custom) {
        this.log(error, custom, null, null);
    }

    public void log(Throwable error, Map<String, Object> custom, Level level) {
        this.log(error, custom, null, level);
    }

    public void log(Throwable error, Level level) {
        this.log(error, null, null, level);
    }

    public void log(Throwable error, String description, Level level) {
        this.log(error, null, description, level);
    }

    public void log(Throwable error, Map<String, Object> custom, String description) {
        this.log(error, custom, description, null);
    }

    public void log(String message) {
        this.log(null, null, message, null);
    }

    public void log(String message, Map<String, Object> custom) {
        this.log(null, custom, message, null);
    }

    public void log(String message, Level level) {
        this.log(null, null, message, level);
    }

    public void log(String message, Map<String, Object> custom, Level level) {
        this.log(null, custom, message, level);
    }

    public void log(Throwable error, Map<String, Object> custom, String description, Level level) {
        this.rollbar.log(error, custom, description, level);
    }

    public void sendJsonPayload(String json) {
        this.rollbar.sendJsonPayload(json);
    }

    @Deprecated
    public static void reportException(Throwable throwable) {
        Rollbar.reportException(throwable, null, null, null);
    }

    @Deprecated
    public static void reportException(Throwable throwable, String level) {
        Rollbar.reportException(throwable, level, null, null);
    }

    @Deprecated
    public static void reportException(Throwable throwable, String level, String description) {
        Rollbar.reportException(throwable, level, description, null);
    }

    @Deprecated
    public static void reportException(final Throwable throwable, final String level, final String description, final Map<String, String> params) {
        Rollbar.ensureInit(new Runnable(){

            @Override
            public void run() {
                notifier.log(throwable, params != null ? Collections.unmodifiableMap(params) : null, description, Level.lookupByName((String)level));
            }
        });
    }

    @Deprecated
    public static void reportMessage(String message) {
        Rollbar.reportMessage(message, null);
    }

    @Deprecated
    public static void reportMessage(String message, String level) {
        Rollbar.reportMessage(message, level, null);
    }

    @Deprecated
    public static void reportMessage(final String message, final String level, final Map<String, String> params) {
        Rollbar.ensureInit(new Runnable(){

            @Override
            public void run() {
                notifier.log(message, params != null ? Collections.unmodifiableMap(params) : null, Level.lookupByName((String)level));
            }
        });
    }

    private String loadAccessTokenFromManifest(Context context) throws PackageManager.NameNotFoundException {
        Context appContext = context.getApplicationContext();
        ApplicationInfo ai = appContext.getPackageManager().getApplicationInfo(appContext.getPackageName(), 128);
        Bundle data = ai.metaData;
        return data.getString(MANIFEST_ACCESS_TOKEN);
    }

    private static void ensureInit(Runnable runnable) {
        if (Rollbar.isInit()) {
            try {
                runnable.run();
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"Exception when interacting with Rollbar", (Throwable)e);
            }
        } else {
            Log.e((String)TAG, (String)"Rollbar not initialized with an access token!");
        }
    }
}

