/*
 * Decompiled with CFR 0.152.
 */
package com.rollbar.android.provider;

import android.os.Build;
import android.util.Log;
import com.rollbar.api.payload.data.Client;
import com.rollbar.notifier.provider.Provider;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;

public class ClientProvider
implements Provider<Client> {
    private final int versionCode;
    private final String versionName;
    private boolean includeLogcat;
    private final int captureIp;
    private final int maxLogcatSize;
    private static final String CAPTURE_IP_ANONYMIZE = "anonymize";
    private static final String CAPTURE_IP_NONE = "none";
    private static final int CAPTURE_IP_TYPE_FULL = 0;
    private static final int CAPTURE_IP_TYPE_ANONYMIZE = 1;
    private static final int CAPTURE_IP_TYPE_NONE = 2;

    ClientProvider(Builder builder) {
        this.versionCode = builder.versionCode;
        this.versionName = builder.versionName;
        this.includeLogcat = builder.includeLogcat;
        this.captureIp = builder.captureIp != null ? (builder.captureIp.equals(CAPTURE_IP_ANONYMIZE) ? 1 : (builder.captureIp.equals(CAPTURE_IP_NONE) ? 2 : 0)) : 0;
        this.maxLogcatSize = builder.maxLogcatSize;
    }

    public Client provide() {
        HashMap<String, Object> androidData = new HashMap<String, Object>();
        androidData.put("phone_model", Build.MODEL);
        androidData.put("android_version", Build.VERSION.RELEASE);
        androidData.put("code_version", this.versionName);
        androidData.put("version_code", this.versionCode);
        androidData.put("version_name", this.versionName);
        if (this.includeLogcat) {
            androidData.put("logs", this.getLogcatInfo());
        }
        Client.Builder clientBuilder = new Client.Builder().addClient("android", androidData).addTopLevel("code_version", (Object)this.versionCode).addTopLevel("name_version", (Object)this.versionName).addTopLevel("version_code", (Object)this.versionCode).addTopLevel("version_name", (Object)this.versionName).addTopLevel("timestamp", (Object)(System.currentTimeMillis() / 1000L));
        if (this.captureIp == 0) {
            clientBuilder.addTopLevel("user_ip", (Object)"$remote_ip");
        } else if (this.captureIp == 1) {
            clientBuilder.addTopLevel("user_ip", (Object)"$remote_ip_anonymize");
        }
        return clientBuilder.build();
    }

    private ArrayList<String> getLogcatInfo() {
        ArrayList log = null;
        int pid = android.os.Process.myPid();
        try {
            String line;
            Process process = Runtime.getRuntime().exec("logcat -d");
            InputStreamReader isr = new InputStreamReader(process.getInputStream());
            BufferedReader br = new BufferedReader(isr, 8192);
            ArrayList<String> lines = new ArrayList<String>();
            while ((line = br.readLine()) != null) {
                if (!line.contains(String.valueOf(pid))) continue;
                lines.add(line);
                if (lines.size() <= this.maxLogcatSize) continue;
                lines.remove(0);
            }
            log = new ArrayList(lines);
        }
        catch (IOException e) {
            Log.e((String)"Rollbar", (String)"Unable to collect logcat info.", (Throwable)e);
        }
        return log;
    }

    public static final class Builder {
        private int versionCode;
        private String versionName;
        private boolean includeLogcat;
        private String captureIp;
        private int maxLogcatSize = 100;

        public Builder versionCode(int versionCode) {
            this.versionCode = versionCode;
            return this;
        }

        public Builder versionName(String versionName) {
            this.versionName = versionName;
            return this;
        }

        public Builder includeLogcat(boolean includeLogcat) {
            this.includeLogcat = includeLogcat;
            return this;
        }

        public Builder captureIp(String captureIp) {
            this.captureIp = captureIp;
            return this;
        }

        public Builder maxLogcatSize(int maxLogcatSize) {
            if (maxLogcatSize >= 0) {
                this.maxLogcatSize = maxLogcatSize;
            }
            return this;
        }

        public ClientProvider build() {
            return new ClientProvider(this);
        }
    }
}

