/*
 * Decompiled with CFR 0.152.
 */
package com.rethinkdb.net;

import com.rethinkdb.gen.exc.ReqlDriverError;
import com.rethinkdb.net.Handshake;
import com.rethinkdb.net.Response;
import com.rethinkdb.net.Util;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Optional;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class SocketWrapper {
    private Socket socket = null;
    private SocketFactory socketFactory = SocketFactory.getDefault();
    private SSLSocket sslSocket = null;
    private OutputStream writeStream = null;
    private DataInputStream readStream = null;
    private Optional<SSLContext> sslContext = Optional.empty();
    private Optional<Long> timeout = Optional.empty();
    private final String hostname;
    private final int port;

    SocketWrapper(String hostname, int port, Optional<SSLContext> sslContext, Optional<Long> timeout) {
        this.hostname = hostname;
        this.port = port;
        this.sslContext = sslContext;
        this.timeout = timeout;
    }

    void connect(Handshake handshake) {
        Optional<Long> deadline = this.timeout.map(Util::deadline);
        try {
            handshake.reset();
            InetSocketAddress addr = new InetSocketAddress(this.hostname, this.port);
            this.socket = this.socketFactory.createSocket();
            this.socket.connect(addr, this.timeout.orElse(0L).intValue());
            this.socket.setTcpNoDelay(true);
            this.socket.setKeepAlive(true);
            if (this.sslContext.isPresent()) {
                this.socketFactory = this.sslContext.get().getSocketFactory();
                SSLSocketFactory sslSf = (SSLSocketFactory)this.socketFactory;
                this.sslSocket = (SSLSocket)sslSf.createSocket(this.socket, this.socket.getInetAddress().getHostAddress(), this.socket.getPort(), true);
                this.readStream = new DataInputStream(this.sslSocket.getInputStream());
                this.writeStream = this.sslSocket.getOutputStream();
                this.sslSocket.startHandshake();
            } else {
                this.writeStream = this.socket.getOutputStream();
                this.readStream = new DataInputStream(this.socket.getInputStream());
            }
            Optional<ByteBuffer> toWrite = handshake.nextMessage(null);
            while (!handshake.isFinished()) {
                if (toWrite.isPresent()) {
                    this.write(toWrite.get());
                }
                String serverMsg = this.readNullTerminatedString(deadline);
                toWrite = handshake.nextMessage(serverMsg);
            }
        }
        catch (IOException e) {
            throw new ReqlDriverError("Connection timed out.", e);
        }
    }

    void write(ByteBuffer buffer) {
        try {
            buffer.flip();
            this.writeStream.write(buffer.array());
        }
        catch (IOException e) {
            throw new ReqlDriverError(e);
        }
    }

    private String readNullTerminatedString(Optional<Long> deadline) throws IOException {
        char c;
        Optional deadlineInstant;
        StringBuilder sb = new StringBuilder();
        Optional<Object> optional = deadlineInstant = deadline.isPresent() ? Optional.of(System.currentTimeMillis() + deadline.get()) : Optional.empty();
        while ((c = (char)this.readStream.readByte()) != '\u0000') {
            if (deadlineInstant.isPresent() && (Long)deadlineInstant.get() < System.currentTimeMillis()) {
                throw new ReqlDriverError("Connection timed out.");
            }
            sb.append(c);
        }
        return sb.toString();
    }

    Response read() throws IOException {
        ByteBuffer header = this.readBytesToBuffer(12);
        long token = header.getLong();
        int responseLength = header.getInt();
        return Response.parseFrom(token, this.readBytesToBuffer(responseLength).order(ByteOrder.LITTLE_ENDIAN));
    }

    private ByteBuffer readBytesToBuffer(int bufsize) throws IOException {
        int res;
        byte[] buf = new byte[bufsize];
        for (int bytesRead = 0; bytesRead < bufsize; bytesRead += res) {
            res = this.readStream.read(buf, bytesRead, bufsize - bytesRead);
            if (res != -1) continue;
            throw new ReqlDriverError("Reached the end of the read stream.");
        }
        return ByteBuffer.wrap(buf).order(ByteOrder.LITTLE_ENDIAN);
    }

    public Optional<Integer> clientPort() {
        Optional<Integer> ret = this.socket != null ? Optional.ofNullable(this.socket.getLocalPort()) : Optional.empty();
        return ret;
    }

    public Optional<SocketAddress> clientAddress() {
        return Optional.ofNullable(this.socket.getLocalSocketAddress());
    }

    boolean isOpen() {
        return this.socket == null ? false : this.socket.isConnected() && !this.socket.isClosed();
    }

    void close() {
        if (this.socket != null && this.isOpen()) {
            try {
                this.socket.close();
            }
            catch (IOException e) {
                throw new ReqlDriverError(e);
            }
        }
    }
}

