/*
 * Decompiled with CFR 0.152.
 */
package com.rethinkdb.gen.exc;

import com.rethinkdb.ast.ReqlAst;
import com.rethinkdb.gen.exc.ReqlError;
import com.rethinkdb.model.Backtrace;
import java.util.Optional;

public class ReqlClientError
extends ReqlError {
    Optional<Backtrace> backtrace = Optional.empty();
    Optional<ReqlAst> term = Optional.empty();

    public ReqlClientError() {
    }

    public ReqlClientError(String message) {
        super(message);
    }

    public ReqlClientError(String format, Object ... args) {
        super(String.format(format, args));
    }

    public ReqlClientError(String message, Throwable cause) {
        super(message, cause);
    }

    public ReqlClientError(Throwable cause) {
        super(cause);
    }

    public ReqlClientError(String msg, ReqlAst term, Backtrace bt) {
        super(msg);
        this.backtrace = Optional.ofNullable(bt);
        this.term = Optional.ofNullable(term);
    }

    @Override
    public ReqlClientError setBacktrace(Backtrace backtrace) {
        this.backtrace = Optional.ofNullable(backtrace);
        return this;
    }

    @Override
    public Optional<Backtrace> getBacktrace() {
        return this.backtrace;
    }

    @Override
    public ReqlClientError setTerm(ReqlAst term) {
        this.term = Optional.ofNullable(term);
        return this;
    }

    @Override
    public Optional<ReqlAst> getTerm() {
        return this.term;
    }
}

