/*
 * Decompiled with CFR 0.152.
 */
package com.rethinkdb.ast;

import com.rethinkdb.gen.exc.ReqlDriverError;
import com.rethinkdb.gen.proto.TermType;
import com.rethinkdb.model.Arguments;
import com.rethinkdb.model.OptArgs;
import com.rethinkdb.net.Connection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.json.simple.JSONArray;

public class ReqlAst {
    protected final TermType termType;
    protected final Arguments args;
    protected final OptArgs optargs;

    protected ReqlAst(TermType termType, Arguments args, OptArgs optargs) {
        if (termType == null) {
            throw new ReqlDriverError("termType can't be null!");
        }
        this.termType = termType;
        this.args = args != null ? args : new Arguments();
        this.optargs = optargs != null ? optargs : new OptArgs();
    }

    protected Object build() {
        JSONArray list = new JSONArray();
        list.add((Object)this.termType.value);
        if (this.args.size() > 0) {
            list.add((Object)this.args.stream().map(ReqlAst::build).collect(Collectors.toCollection(JSONArray::new)));
        } else {
            list.add((Object)new JSONArray());
        }
        if (this.optargs.size() > 0) {
            list.add(ReqlAst.buildOptarg(this.optargs));
        }
        return list;
    }

    public static Map<String, Object> buildOptarg(OptArgs opts) {
        HashMap<String, Object> result = new HashMap<String, Object>(opts.size());
        opts.forEach((name, arg) -> result.put((String)name, arg.build()));
        return result;
    }

    public <T> T run(Connection conn) {
        return conn.run(this, new OptArgs(), Optional.empty());
    }

    public <T> T run(Connection conn, OptArgs runOpts) {
        return conn.run(this, runOpts, Optional.empty());
    }

    public <T, P> T run(Connection conn, Class<P> pojoClass) {
        return conn.run(this, new OptArgs(), Optional.of(pojoClass));
    }

    public <T, P> T run(Connection conn, OptArgs runOpts, Class<P> pojoClass) {
        return conn.run(this, runOpts, Optional.of(pojoClass));
    }

    public void runNoReply(Connection conn) {
        conn.runNoReply(this, new OptArgs());
    }

    public void runNoReply(Connection conn, OptArgs globalOpts) {
        conn.runNoReply(this, globalOpts);
    }

    public String toString() {
        return "ReqlAst{termType=" + (Object)((Object)this.termType) + ", args=" + this.args + ", optargs=" + this.optargs + '}';
    }
}

