/*
 * Decompiled with CFR 0.152.
 */
package com.reprezen.kaizen.oasparser.val3;

import com.reprezen.jsonoverlay.IJsonOverlay;
import com.reprezen.jsonoverlay.JsonOverlay;
import com.reprezen.jsonoverlay.Overlay;
import com.reprezen.jsonoverlay.PropertiesOverlay;
import com.reprezen.kaizen.oasparser.model3.Example;
import com.reprezen.kaizen.oasparser.model3.MediaType;
import com.reprezen.kaizen.oasparser.model3.Parameter;
import com.reprezen.kaizen.oasparser.model3.Path;
import com.reprezen.kaizen.oasparser.model3.Schema;
import com.reprezen.kaizen.oasparser.val.ObjectValidatorBase;
import com.reprezen.kaizen.oasparser.val.msg.Messages;
import com.reprezen.kaizen.oasparser.val3.ExampleValidator;
import com.reprezen.kaizen.oasparser.val3.MediaTypeValidator;
import com.reprezen.kaizen.oasparser.val3.OpenApi3Messages;
import com.reprezen.kaizen.oasparser.val3.Regexes;
import com.reprezen.kaizen.oasparser.val3.SchemaValidator;
import java.util.Map;
import java.util.function.Consumer;

public class ParameterValidator
extends ObjectValidatorBase<Parameter> {
    @Override
    public void runObjectValidations() {
        Parameter parameter = (Parameter)this.value.getOverlay();
        this.validateStringField("description", false);
        this.validateBooleanField("deprecated", false);
        this.validateBooleanField("allowEmptyValue", false);
        this.validateBooleanField("explode", false);
        Overlay<Object> example = this.validateField("example", false, Object.class, null, new Consumer[0]);
        Overlay<Map<String, Example>> examples = this.validateMapField("examples", false, false, Example.class, new ExampleValidator());
        this.checkExampleExclusion(examples, example);
        this.validateStringField("name", true);
        this.validateStringField("in", true, Regexes.PARAM_IN_REGEX, new Consumer[0]);
        this.checkPathParam(parameter);
        this.checkRequired(parameter);
        this.validateStringField("style", false, Regexes.STYLE_REGEX, new Consumer[0]);
        this.checkAllowReserved(parameter);
        this.validateField("schema", false, Schema.class, new SchemaValidator(), new Consumer[0]);
        this.validateMapField("contentMediaTypes", false, false, MediaType.class, new MediaTypeValidator());
        this.validateExtensions(parameter.getExtensions());
    }

    private void checkPathParam(Parameter parameter) {
        String path;
        if (parameter.getIn() != null && parameter.getIn().equals("path") && parameter.getName() != null && (path = this.getPathString(parameter)) != null && !path.matches(".*\\{" + parameter.getName() + "\\}(.*)?")) {
            this.results.addError(Messages.msg(OpenApi3Messages.MissingPathTplt, parameter.getName(), path), this.value);
        }
    }

    private void checkRequired(Parameter parameter) {
        if ("path".equals(parameter.getIn()) && parameter.getRequired() != Boolean.TRUE) {
            this.results.addError(Messages.msg(OpenApi3Messages.PathParamReq, parameter.getName()), this.value);
        }
    }

    private void checkAllowReserved(Parameter parameter) {
        if (parameter.isAllowReserved() && !"query".equals(parameter.getIn())) {
            this.results.addWarning(Messages.msg(OpenApi3Messages.NonQryAllowRsvd, parameter.getName(), parameter.getIn()), this.value);
        }
    }

    private String getPathString(Parameter parameter) {
        PropertiesOverlay parent = Overlay.of((IJsonOverlay)parameter).getParentPropertiesOverlay();
        while (parent != null && !(parent instanceof Path)) {
            parent = Overlay.of((JsonOverlay)parent).getParentPropertiesOverlay();
        }
        return parent != null && parent instanceof Path ? Overlay.getPathInParent((JsonOverlay)parent) : null;
    }

    void checkExampleExclusion(Overlay<Map<String, Example>> examples, Overlay<Object> example) {
        boolean examplePresent;
        boolean examplesPresent = examples != null && examples.isPresent() && Overlay.getMapOverlay(examples).size() > 0;
        boolean bl = examplePresent = example != null && example.isPresent();
        if (examplesPresent && examplePresent) {
            this.results.addError("ExmplExclusion|The 'example' and 'exmaples' properties may not both appear", this.value);
        }
    }
}

