/*
 * Decompiled with CFR 0.152.
 */
package com.relevantcodes.extentreports;

import com.relevantcodes.extentreports.Configuration;
import com.relevantcodes.extentreports.DisplayOrder;
import com.relevantcodes.extentreports.ExtentTest;
import com.relevantcodes.extentreports.ExtentTestInterruptedException;
import com.relevantcodes.extentreports.IReporter;
import com.relevantcodes.extentreports.LogSettings;
import com.relevantcodes.extentreports.LogStatus;
import com.relevantcodes.extentreports.NetworkMode;
import com.relevantcodes.extentreports.SystemInfo;
import com.relevantcodes.extentreports.converters.TimeConverter;
import com.relevantcodes.extentreports.model.Category;
import com.relevantcodes.extentreports.model.ExceptionInfo;
import com.relevantcodes.extentreports.model.Log;
import com.relevantcodes.extentreports.model.SuiteTimeInfo;
import com.relevantcodes.extentreports.model.Test;
import com.relevantcodes.extentreports.model.TestAttribute;
import com.relevantcodes.extentreports.utils.DateTimeUtil;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class Report
extends LogSettings {
    private static final Logger LOGGER = Logger.getLogger(Report.class.getName());
    private static final String INTERNAL_WARNING = "Close was called before test could end safely using EndTest.";
    private static final String DEFAULT_PROTOCOL = "https";
    private final String CONFIG_FILE = "extent-config.xml";
    private String filePath;
    private DisplayOrder displayOrder;
    private NetworkMode networkMode;
    private Boolean replaceExisting;
    private LogStatus reportStatus = LogStatus.UNKNOWN;
    private Date startedTime;
    private long totalDurationPastRun = 0L;
    private String currentSuiteRunDuration;
    private List<String> testRunnerLogList;
    private List<LogStatus> logStatusList;
    private List<IReporter> reporters;
    private Test test;
    private UUID reportId;
    private Boolean terminated = false;
    private Map<String, List<Test>> categoryTestMap;
    private Map<String, List<ExceptionInfo>> exceptionTestMap;
    private Map<String, String> configurationMap;
    private Map<String, String> defaultConfiguration;
    private Locale locale = Locale.ENGLISH;
    private String mongoDBID = "";
    private String projectName = "Default";
    protected SuiteTimeInfo suiteTimeInfo;
    protected SystemInfo systemInfo;
    protected List<ExtentTest> testList;
    protected File configFile = null;

    protected List<ExtentTest> getTestList() {
        return this.testList;
    }

    protected void updateTestQueue(ExtentTest extentTest) {
        if (this.displayOrder == DisplayOrder.OLDEST_FIRST) {
            this.testList.add(extentTest);
        } else {
            this.testList.add(0, extentTest);
        }
    }

    protected List<LogStatus> getLogStatusList() {
        return this.logStatusList;
    }

    protected Date getStartedTime() {
        return this.startedTime;
    }

    protected String getRunDuration() {
        this.currentSuiteRunDuration = DateTimeUtil.getDiff(Calendar.getInstance().getTime(), new Date(this.suiteTimeInfo.getSuiteStartTimestamp()));
        return this.currentSuiteRunDuration;
    }

    protected String getRunDurationOverall() {
        if (this.totalDurationPastRun == 0L) {
            if (this.currentSuiteRunDuration == null) {
                this.getRunDuration();
            }
            return this.currentSuiteRunDuration;
        }
        long millis = Calendar.getInstance().getTime().getTime() - this.startedTime.getTime();
        long hours = TimeUnit.MILLISECONDS.toHours(millis += this.totalDurationPastRun);
        long mins = TimeUnit.MILLISECONDS.toMinutes(millis);
        long secs = TimeUnit.MILLISECONDS.toSeconds(millis);
        return DateTimeUtil.getHMS(hours, mins, secs, millis -= secs * 1000L);
    }

    protected void convertUpdateLastRunDuration() {
        this.totalDurationPastRun = new TimeConverter(this.filePath).getLastRunDurationMillis();
    }

    protected List<String> getTestRunnerLogList() {
        return this.testRunnerLogList;
    }

    protected Map<String, String> getConfigurationMap() {
        return this.configurationMap;
    }

    protected Map<String, List<Test>> getCategoryTestMap() {
        return this.categoryTestMap;
    }

    protected Map<String, List<ExceptionInfo>> getExceptionTestMap() {
        return this.exceptionTestMap;
    }

    protected SystemInfo getSystemInfo() {
        return this.systemInfo;
    }

    protected Map<String, String> getSystemInfoMap() {
        return this.getSystemInfo().getInfo();
    }

    protected void attach(IReporter reporter) {
        if (this.reporters == null) {
            this.reporters = new ArrayList<IReporter>();
        }
        this.reporters.add(reporter);
        reporter.start(this);
    }

    protected void detach(IReporter reporter) {
        reporter.stop();
        this.reporters.remove(reporter);
    }

    protected void finalizeTest(Test test) {
        if (test.getEndedTime() == null) {
            test.setEndedTime(Calendar.getInstance().getTime());
        }
        Test.TestAttributeIterator<Category> catIter = test.categoryIterator();
        while (catIter.hasNext()) {
            TestAttribute category = (TestAttribute)catIter.next();
            if (!this.categoryTestMap.containsKey(category.getName())) {
                ArrayList testList = new ArrayList();
                testList.add(test);
                this.categoryTestMap.put(category.getName(), testList);
                continue;
            }
            this.categoryTestMap.get(category.getName()).add(test);
        }
        List<ExceptionInfo> exceptionList = test.getExceptionList();
        if (exceptionList != null) {
            for (ExceptionInfo exceptionInfo : exceptionList) {
                this.setCauseTest(exceptionInfo);
            }
        }
        Test.LogIterator logIter = test.logIterator();
        while (logIter.hasNext()) {
            Log log = (Log)logIter.next();
            if (!log.getTimestamp().after(test.getEndedTime())) continue;
            log.setTimestamp(test.getEndedTime());
        }
        test.prepareFinalize();
        this.test = test;
        for (IReporter reporter : this.reporters) {
            reporter.addTest(test);
        }
        this.updateReportStatus(test.getStatus());
        this.updateReportStartedTime(test);
    }

    private void setCauseTest(ExceptionInfo exceptionInfo) {
        String ex = exceptionInfo.getExceptionName();
        if (!this.exceptionTestMap.containsKey(ex)) {
            this.exceptionTestMap.put(ex, new ArrayList());
            this.exceptionTestMap.get(ex).add(exceptionInfo);
        }
    }

    private void updateTestStatusList(Test test) {
        Boolean toAdd = false;
        toAdd = test.getStatus() == LogStatus.FATAL || test.getStatus() == LogStatus.ERROR || test.getStatus() == LogStatus.WARNING || test.getStatus() == LogStatus.UNKNOWN;
        if (toAdd.booleanValue() && !this.logStatusList.contains((Object)test.getStatus())) {
            this.logStatusList.add(test.getStatus());
        }
        if (test.hasChildNodes) {
            List<Test> nodeList = test.getNodeList();
            for (Test node : nodeList) {
                this.updateTestStatusList(node);
            }
        }
    }

    private void updateReportStartedTime(Test test) {
        long testStartedTime = test.getStartedTime().getTime();
        if (this.suiteTimeInfo.getSuiteStartTimestamp() > testStartedTime) {
            this.suiteTimeInfo.setSuiteStartTimestamp(testStartedTime);
        }
    }

    protected void terminate() {
        for (ExtentTest extentTest : this.testList) {
            Test test = extentTest.getInternalTest();
            if (test.hasEnded) continue;
            ExtentTestInterruptedException e = new ExtentTestInterruptedException(INTERNAL_WARNING);
            test.setInternalWarning(INTERNAL_WARNING);
            extentTest.log(LogStatus.FAIL, e);
            test.hasEnded = true;
            this.finalizeTest(test);
        }
        this.flush();
        Iterator<IReporter> iter = this.reporters.iterator();
        while (iter.hasNext()) {
            iter.next().stop();
            iter.remove();
        }
        this.terminated = true;
    }

    protected void flush() {
        if (this.terminated.booleanValue()) {
            try {
                throw new IOException("Unable to write source: Stream closed.");
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, "Stream closed", e);
                return;
            }
        }
        this.suiteTimeInfo.setSuiteEndTimestamp(new Date().getTime());
        if (this.getTestList() != null) {
            for (ExtentTest test : this.getTestList()) {
                this.updateTestStatusList(test.getInternalTest());
            }
            for (IReporter reporter : this.reporters) {
                reporter.flush();
            }
        }
    }

    protected Map<String, String> loadConfig(Configuration config) {
        this.configurationMap = config.getConfigurationMap();
        if (this.defaultConfiguration != null) {
            for (Map.Entry<String, String> entry : this.defaultConfiguration.entrySet()) {
                if (this.configurationMap.containsKey(entry.getKey())) continue;
                this.configurationMap.put(entry.getKey(), entry.getValue());
            }
        }
        this.updateBaseDefaultSettings(this.configurationMap);
        return this.configurationMap;
    }

    private void updateBaseDefaultSettings(Map<String, String> configurationMap) {
        if (configurationMap.get("dateFormat") != null && !configurationMap.get("dateFormat").isEmpty()) {
            Report.setLogDateFormat(configurationMap.get("dateFormat"));
        } else {
            configurationMap.put("dateFormat", Report.getLogDateFormat());
        }
        if (configurationMap.get("timeFormat") != null && !configurationMap.get("timeFormat").isEmpty()) {
            Report.setLogTimeFormat(configurationMap.get("timeFormat"));
        } else {
            configurationMap.put("timeFormat", Report.getLogTimeFormat());
        }
        if (configurationMap.get("protocol") == null || configurationMap.get("protocol").isEmpty()) {
            configurationMap.put("protocol", DEFAULT_PROTOCOL);
        }
    }

    protected void setTestRunnerLogs(String logs) {
        this.testRunnerLogList.add(logs);
    }

    protected Test getCurrentTest() {
        return this.test;
    }

    protected void setFilePath(String filePath) {
        this.filePath = filePath;
        File reportFile = new File(filePath);
        if (reportFile.getParentFile() != null && !reportFile.getParentFile().exists()) {
            reportFile.getParentFile().mkdirs();
        }
    }

    protected String getFilePath() {
        return this.filePath;
    }

    protected void setReplaceExisting(Boolean replaceExisting) {
        this.replaceExisting = replaceExisting;
    }

    protected Boolean getReplaceExisting() {
        return this.replaceExisting;
    }

    protected void setDisplayOrder(DisplayOrder displayOrder) {
        this.displayOrder = displayOrder;
    }

    protected DisplayOrder getDisplayOrder() {
        return this.displayOrder;
    }

    protected void setNetworkMode(NetworkMode networkMode) {
        this.networkMode = networkMode;
    }

    protected NetworkMode getNetworkMode() {
        return this.networkMode;
    }

    protected UUID getId() {
        return this.reportId;
    }

    protected LogStatus getStatus() {
        return this.reportStatus;
    }

    protected SuiteTimeInfo getSuiteTimeInfo() {
        return this.suiteTimeInfo;
    }

    protected void setStartedTime(long startTime) {
        this.suiteTimeInfo.setSuiteStartTimestamp(startTime);
    }

    protected void setDocumentLocale(Locale locale) {
        this.locale = locale;
    }

    protected Locale getDocumentLocale() {
        return this.locale;
    }

    protected void setProjectName(String name) {
        this.projectName = name;
    }

    public String getProjectName() {
        return this.projectName;
    }

    protected void setMongoDBObjectID(String id) {
        this.mongoDBID = id;
    }

    public String getMongoDBObjectID() {
        return this.mongoDBID;
    }

    protected Report() {
        String resourceFile = Report.class.getPackage().getName().replace(".", "/") + "/resources/" + "extent-config.xml";
        URL url = this.getClass().getClassLoader().getResource(resourceFile);
        this.defaultConfiguration = this.loadConfig(new Configuration(url));
        this.categoryTestMap = new TreeMap<String, List<Test>>();
        this.exceptionTestMap = new TreeMap<String, List<ExceptionInfo>>();
        this.systemInfo = new SystemInfo();
        this.suiteTimeInfo = new SuiteTimeInfo();
        this.testRunnerLogList = new ArrayList<String>();
        this.logStatusList = new ArrayList<LogStatus>();
        this.reportId = UUID.randomUUID();
        this.startedTime = new Date(this.suiteTimeInfo.getSuiteStartTimestamp());
    }

    private void updateReportStatus(LogStatus logStatus) {
        if (this.reportStatus == LogStatus.FATAL) {
            return;
        }
        if (logStatus == LogStatus.FATAL) {
            this.reportStatus = logStatus;
            return;
        }
        if (this.reportStatus == LogStatus.FAIL) {
            return;
        }
        if (logStatus == LogStatus.FAIL) {
            this.reportStatus = logStatus;
            return;
        }
        if (this.reportStatus == LogStatus.ERROR) {
            return;
        }
        if (logStatus == LogStatus.ERROR) {
            this.reportStatus = logStatus;
            return;
        }
        if (this.reportStatus == LogStatus.WARNING) {
            return;
        }
        if (logStatus == LogStatus.WARNING) {
            this.reportStatus = logStatus;
            return;
        }
        if (this.reportStatus == LogStatus.SKIP) {
            return;
        }
        if (logStatus == LogStatus.SKIP) {
            this.reportStatus = LogStatus.SKIP;
            return;
        }
        if (this.reportStatus == LogStatus.PASS) {
            return;
        }
        if (logStatus == LogStatus.PASS) {
            this.reportStatus = LogStatus.PASS;
            return;
        }
        if (this.reportStatus == LogStatus.INFO) {
            return;
        }
        if (logStatus == LogStatus.INFO) {
            this.reportStatus = LogStatus.INFO;
            return;
        }
        this.reportStatus = LogStatus.UNKNOWN;
    }
}

