/*
 * Decompiled with CFR 0.152.
 */
package org.finos.rune.mapper.processor.collector;

import java.util.Map;
import org.finos.rune.mapper.processor.KeyRecord;

public class KeyLookupService {
    private final Map<KeyRecord, Object> globalKeyToValueObjectMap;
    private final Map<KeyRecord, Object> externalKeyToValueObjectMap;
    private final Map<KeyRecord, Object> addressToValueObjectMap;

    public KeyLookupService(Map<KeyRecord, Object> globalKeyToValueObjectMap, Map<KeyRecord, Object> externalKeyToValueObjectMap, Map<KeyRecord, Object> addressToValueObjectMap) {
        this.globalKeyToValueObjectMap = globalKeyToValueObjectMap;
        this.externalKeyToValueObjectMap = externalKeyToValueObjectMap;
        this.addressToValueObjectMap = addressToValueObjectMap;
    }

    public Object getReferencedObject(KeyType keyType, Class<?> keyOnType, String id) {
        switch (keyType.ordinal()) {
            case 0: {
                return this.globalKeyToValueObjectMap.get(new KeyRecord(keyOnType, id));
            }
            case 1: {
                return this.externalKeyToValueObjectMap.get(new KeyRecord(keyOnType, id));
            }
            case 2: {
                return this.addressToValueObjectMap.get(new KeyRecord(keyOnType, id));
            }
        }
        throw new IllegalArgumentException("Unknown key type: " + (Object)((Object)keyType));
    }

    public static enum KeyType {
        GLOBAL_KEY,
        EXTERNAL_KEY,
        ADDRESS;

    }
}

