/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.variance.swaps;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.eq.shared.ExtraordinaryEvents;
import fpml.consolidated.eq.shared.NettedSwapBase;
import fpml.consolidated.option.shared.ClassifiablePayment;
import fpml.consolidated.shared.ProductModel;
import fpml.consolidated.variance.swaps.VarianceLeg;
import fpml.consolidated.variance.swaps.meta.VarianceSwapMeta;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="VarianceSwap", builder=VarianceSwapBuilderImpl.class, version="1.2.2")
@RuneDataType(value="VarianceSwap", model="fpml", builder=VarianceSwapBuilderImpl.class, version="1.2.2")
public interface VarianceSwap
extends NettedSwapBase {
    public static final VarianceSwapMeta metaData = new VarianceSwapMeta();

    public List<? extends VarianceLeg> getVarianceLeg();

    @Override
    public VarianceSwap build();

    @Override
    public VarianceSwapBuilder toBuilder();

    public static VarianceSwapBuilder builder() {
        return new VarianceSwapBuilderImpl();
    }

    default public RosettaMetaData<? extends VarianceSwap> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends VarianceSwap> getType() {
        return VarianceSwap.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("productModel"), processor, ProductModel.class, this.getProductModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("additionalPayment"), processor, ClassifiablePayment.class, this.getAdditionalPayment(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("extraordinaryEvents"), processor, ExtraordinaryEvents.class, this.getExtraordinaryEvents(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("varianceLeg"), processor, VarianceLeg.class, this.getVarianceLeg(), new AttributeMeta[0]);
    }

    public static class VarianceSwapBuilderImpl
    extends NettedSwapBase.NettedSwapBaseBuilderImpl
    implements VarianceSwapBuilder {
        protected List<VarianceLeg.VarianceLegBuilder> varianceLeg = new ArrayList<VarianceLeg.VarianceLegBuilder>();

        @Override
        @RosettaAttribute(value="varianceLeg", isRequired=true)
        @RuneAttribute(value="varianceLeg", isRequired=true)
        public List<? extends VarianceLeg.VarianceLegBuilder> getVarianceLeg() {
            return this.varianceLeg;
        }

        @Override
        public VarianceLeg.VarianceLegBuilder getOrCreateVarianceLeg(int index) {
            if (this.varianceLeg == null) {
                this.varianceLeg = new ArrayList<VarianceLeg.VarianceLegBuilder>();
            }
            return (VarianceLeg.VarianceLegBuilder)this.getIndex(this.varianceLeg, index, () -> {
                VarianceLeg.VarianceLegBuilder newVarianceLeg = VarianceLeg.builder();
                return newVarianceLeg;
            });
        }

        @Override
        @RosettaAttribute(value="productModel")
        @RuneAttribute(value="productModel")
        public VarianceSwapBuilder setProductModel(ProductModel _productModel) {
            this.productModel = _productModel == null ? null : _productModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public VarianceSwapBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="additionalPayment")
        @RuneAttribute(value="additionalPayment")
        public VarianceSwapBuilder addAdditionalPayment(ClassifiablePayment _additionalPayment) {
            if (_additionalPayment != null) {
                this.additionalPayment.add(_additionalPayment.toBuilder());
            }
            return this;
        }

        @Override
        public VarianceSwapBuilder addAdditionalPayment(ClassifiablePayment _additionalPayment, int idx) {
            this.getIndex(this.additionalPayment, idx, () -> _additionalPayment.toBuilder());
            return this;
        }

        @Override
        public VarianceSwapBuilder addAdditionalPayment(List<? extends ClassifiablePayment> additionalPayments) {
            if (additionalPayments != null) {
                for (ClassifiablePayment classifiablePayment : additionalPayments) {
                    this.additionalPayment.add(classifiablePayment.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="additionalPayment")
        public VarianceSwapBuilder setAdditionalPayment(List<? extends ClassifiablePayment> additionalPayments) {
            this.additionalPayment = additionalPayments == null ? new ArrayList() : (List)additionalPayments.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="extraordinaryEvents")
        @RuneAttribute(value="extraordinaryEvents")
        public VarianceSwapBuilder setExtraordinaryEvents(ExtraordinaryEvents _extraordinaryEvents) {
            this.extraordinaryEvents = _extraordinaryEvents == null ? null : _extraordinaryEvents.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="varianceLeg", isRequired=true)
        @RuneAttribute(value="varianceLeg", isRequired=true)
        public VarianceSwapBuilder addVarianceLeg(VarianceLeg _varianceLeg) {
            if (_varianceLeg != null) {
                this.varianceLeg.add(_varianceLeg.toBuilder());
            }
            return this;
        }

        @Override
        public VarianceSwapBuilder addVarianceLeg(VarianceLeg _varianceLeg, int idx) {
            this.getIndex(this.varianceLeg, idx, () -> _varianceLeg.toBuilder());
            return this;
        }

        @Override
        public VarianceSwapBuilder addVarianceLeg(List<? extends VarianceLeg> varianceLegs) {
            if (varianceLegs != null) {
                for (VarianceLeg varianceLeg : varianceLegs) {
                    this.varianceLeg.add(varianceLeg.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="varianceLeg")
        public VarianceSwapBuilder setVarianceLeg(List<? extends VarianceLeg> varianceLegs) {
            this.varianceLeg = varianceLegs == null ? new ArrayList<VarianceLeg.VarianceLegBuilder>() : (List)varianceLegs.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public VarianceSwap build() {
            return new VarianceSwapImpl(this);
        }

        @Override
        public VarianceSwapBuilder toBuilder() {
            return this;
        }

        @Override
        public VarianceSwapBuilder prune() {
            super.prune();
            this.varianceLeg = this.varianceLeg.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            return this.getVarianceLeg() != null && this.getVarianceLeg().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        @Override
        public VarianceSwapBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            VarianceSwapBuilder o = (VarianceSwapBuilder)other;
            merger.mergeRosetta(this.getVarianceLeg(), o.getVarianceLeg(), this::getOrCreateVarianceLeg);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            VarianceSwap _that = (VarianceSwap)this.getType().cast(o);
            return ListEquals.listEquals(this.varianceLeg, _that.getVarianceLeg());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.varianceLeg != null ? this.varianceLeg.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "VarianceSwapBuilder {varianceLeg=" + String.valueOf(this.varianceLeg) + "} " + super.toString();
        }
    }

    public static interface VarianceSwapBuilder
    extends VarianceSwap,
    NettedSwapBase.NettedSwapBaseBuilder {
        public VarianceLeg.VarianceLegBuilder getOrCreateVarianceLeg(int var1);

        public List<? extends VarianceLeg.VarianceLegBuilder> getVarianceLeg();

        @Override
        public VarianceSwapBuilder setProductModel(ProductModel var1);

        @Override
        public VarianceSwapBuilder setId(String var1);

        @Override
        public VarianceSwapBuilder addAdditionalPayment(ClassifiablePayment var1);

        @Override
        public VarianceSwapBuilder addAdditionalPayment(ClassifiablePayment var1, int var2);

        @Override
        public VarianceSwapBuilder addAdditionalPayment(List<? extends ClassifiablePayment> var1);

        @Override
        public VarianceSwapBuilder setAdditionalPayment(List<? extends ClassifiablePayment> var1);

        @Override
        public VarianceSwapBuilder setExtraordinaryEvents(ExtraordinaryEvents var1);

        public VarianceSwapBuilder addVarianceLeg(VarianceLeg var1);

        public VarianceSwapBuilder addVarianceLeg(VarianceLeg var1, int var2);

        public VarianceSwapBuilder addVarianceLeg(List<? extends VarianceLeg> var1);

        public VarianceSwapBuilder setVarianceLeg(List<? extends VarianceLeg> var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("productModel"), processor, ProductModel.ProductModelBuilder.class, (RosettaModelObjectBuilder)this.getProductModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("additionalPayment"), processor, ClassifiablePayment.ClassifiablePaymentBuilder.class, this.getAdditionalPayment(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("extraordinaryEvents"), processor, ExtraordinaryEvents.ExtraordinaryEventsBuilder.class, (RosettaModelObjectBuilder)this.getExtraordinaryEvents(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("varianceLeg"), processor, VarianceLeg.VarianceLegBuilder.class, this.getVarianceLeg(), new AttributeMeta[0]);
        }

        @Override
        public VarianceSwapBuilder prune();
    }

    public static class VarianceSwapImpl
    extends NettedSwapBase.NettedSwapBaseImpl
    implements VarianceSwap {
        private final List<? extends VarianceLeg> varianceLeg;

        protected VarianceSwapImpl(VarianceSwapBuilder builder) {
            super(builder);
            this.varianceLeg = Optional.ofNullable(builder.getVarianceLeg()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="varianceLeg", isRequired=true)
        @RuneAttribute(value="varianceLeg", isRequired=true)
        public List<? extends VarianceLeg> getVarianceLeg() {
            return this.varianceLeg;
        }

        @Override
        public VarianceSwap build() {
            return this;
        }

        @Override
        public VarianceSwapBuilder toBuilder() {
            VarianceSwapBuilder builder = VarianceSwap.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(VarianceSwapBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getVarianceLeg()).ifPresent(builder::setVarianceLeg);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            VarianceSwap _that = (VarianceSwap)this.getType().cast(o);
            return ListEquals.listEquals(this.varianceLeg, _that.getVarianceLeg());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.varianceLeg != null ? this.varianceLeg.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "VarianceSwap {varianceLeg=" + String.valueOf(this.varianceLeg) + "} " + super.toString();
        }
    }
}

