/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.shared.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import fpml.consolidated.shared.Resource;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="ResourceChoice")
@ImplementedBy(value=Default.class)
public interface ResourceChoice
extends Validator<Resource> {
    public static final String NAME = "ResourceChoice";
    public static final String DEFINITION = "optional choice string, hexadecimalBinary , base64Binary , url";

    public static class NoOp
    implements ResourceChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, Resource resource) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements ResourceChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, Resource resource) {
            ComparisonResult result = this.executeDataRule(resource);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)ResourceChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Resource", (RosettaPath)path, (String)ResourceChoice.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)ResourceChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Resource", (RosettaPath)path, (String)ResourceChoice.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(Resource resource) {
            try {
                return ExpressionOperators.choice((Mapper)MapperS.of((Object)resource), Arrays.asList("string", "hexadecimalBinary", "base64Binary", "url"), (ChoiceRuleValidationMethod)ChoiceRuleValidationMethod.OPTIONAL);
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

